/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class FluidFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(class_1799 stack) {
        return new FluidFilter(stack);
    }

    @Override
    public ItemFilter readFilter(class_2520 tag, class_7225.class_7874 provider) {
        return new FluidFilter(tag, provider);
    }

    private static class FluidFilter
    extends ItemFilter {
        FluidVariant stack;

        public FluidFilter(class_1799 stack) {
            this.stack = FluidFilter.getFluid(stack);
        }

        public FluidFilter(class_2520 tag, class_7225.class_7874 provider) {
            this.stack = (FluidVariant)((Pair)FluidVariant.CODEC.decode((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).getOrThrow()).getFirst();
        }

        @Override
        public boolean matches(Object stack) {
            FluidVariant fluid = stack instanceof FluidVariant ? (FluidVariant)stack : (stack instanceof class_1799 ? FluidFilter.getFluid((class_1799)stack) : null);
            return fluid != null && fluid.equals((Object)this.stack);
        }

        @Override
        public class_1799 getRepresentingItem() {
            return new class_1799((class_1935)this.stack.getFluid().method_15774());
        }

        @Override
        public class_2520 write(class_7225.class_7874 provider) {
            return (class_2520)FluidVariant.CODEC.encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)this.stack).getOrThrow();
        }

        @Override
        public boolean isValid() {
            return this.stack != null && !this.stack.isBlank();
        }

        private static FluidVariant getFluid(class_1799 stack) {
            Storage fluidHandler = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
            if (fluidHandler != null) {
                for (StorageView slot : fluidHandler) {
                    if (slot.isResourceBlank()) continue;
                    return (FluidVariant)slot.getResource();
                }
            }
            return FluidVariant.blank();
        }
    }
}

