/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class LimitedExecutor
implements Executor,
Runnable {
    private final Executor inner;
    private final int maxConcurrency;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final Object lock = new Object();
    private int activeWorkers;

    public LimitedExecutor(Executor inner, int maxConcurrency) {
        this.inner = inner;
        this.maxConcurrency = maxConcurrency;
    }

    public int queueSize() {
        return this.queue.size();
    }

    public int activeWorkers() {
        return this.activeWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NotNull Runnable runnable) {
        this.queue.add(runnable);
        Object object = this.lock;
        synchronized (object) {
            if (this.activeWorkers < this.maxConcurrency) {
                ++this.activeWorkers;
                this.inner.execute(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Runnable runnable;
            if ((runnable = this.queue.poll()) != null) {
                runnable.run();
                continue;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    --this.activeWorkers;
                    return;
                }
            }
        }
    }
}

