/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.Mod;
import xerca.xercapaint.item.ItemCanvas;
import xerca.xercapaint.item.ItemPalette;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.ImportPaintingPacket;

public class CommandImport {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"paintimport").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandImport.paintImport((class_2168)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintImport(class_2168 stack, String name) {
        Mod.LOGGER.debug("Paint import called. name: {}", (Object)name);
        ImportPaintingPacket pack = new ImportPaintingPacket(name);
        try {
            class_3222 player = stack.method_9207();
            ServerPlayNetworking.send((class_3222)player, (class_8710)pack);
        }
        catch (CommandSyntaxException e) {
            Mod.LOGGER.debug("Command executor is not a player");
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public static void doImport(class_2487 tag, class_3222 player) {
        class_1799 itemStack;
        if (!tag.method_10573("name", 8)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.fail.5").method_27692(class_124.field_1061));
            Mod.LOGGER.warn("Broken paint file");
            return;
        }
        String canvasId = tag.method_10558("name");
        if (!canvasId.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}_[0-9]+$")) {
            player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.fail.5").method_27692(class_124.field_1061));
            Mod.LOGGER.warn("Broken paint file");
            return;
        }
        if (tag.method_10573("author", 8) && !tag.method_10573("title", 8) || !tag.method_10573("author", 8) && tag.method_10573("title", 8)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.fail.5").method_27692(class_124.field_1061));
            Mod.LOGGER.warn("Broken paint file");
            return;
        }
        if (tag.method_10573("title", 8) && tag.method_10558("title").length() > 16) {
            tag.method_10582("title", tag.method_10558("title").substring(0, 16));
        }
        if (tag.method_10573("author", 8) && tag.method_10558("author").length() > 16) {
            tag.method_10582("author", tag.method_10558("author").substring(0, 16));
        }
        if (!tag.method_10573("v", 3)) {
            tag.method_10569("v", 1);
        }
        byte canvasType = tag.method_10571("ct");
        tag.method_10551("ct");
        if (tag.method_10550("generation") > 0) {
            tag.method_10569("generation", tag.method_10550("generation") + 1);
        }
        boolean doAddItem = false;
        if (player.method_7337()) {
            CanvasType type = CanvasType.fromByte(canvasType);
            if (type == null) {
                Mod.LOGGER.error("Invalid canvas type");
                return;
            }
            switch (type) {
                case SMALL: {
                    itemStack = new class_1799((class_1935)Items.ITEM_CANVAS);
                    break;
                }
                case LONG: {
                    itemStack = new class_1799((class_1935)Items.ITEM_CANVAS_LONG);
                    break;
                }
                case TALL: {
                    itemStack = new class_1799((class_1935)Items.ITEM_CANVAS_TALL);
                    break;
                }
                case LARGE: {
                    itemStack = new class_1799((class_1935)Items.ITEM_CANVAS_LARGE);
                    break;
                }
                default: {
                    Mod.LOGGER.error("Unknown canvas type");
                    return;
                }
            }
            doAddItem = true;
        } else {
            class_1799 mainhand = player.method_6047();
            class_1799 offhand = player.method_6079();
            if (!(mainhand.method_7909() instanceof ItemCanvas) || mainhand.method_57824(Items.CANVAS_PIXELS) != null || mainhand.method_57824(Items.CANVAS_ID) != null) {
                player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.fail.1").method_27692(class_124.field_1061));
                return;
            }
            if (((ItemCanvas)mainhand.method_7909()).getCanvasType() != CanvasType.fromByte(canvasType)) {
                class_2561 typeName = Items.ITEM_CANVAS.method_7864(class_1799.field_8037);
                CanvasType type = CanvasType.fromByte(canvasType);
                if (type == null) {
                    return;
                }
                switch (type) {
                    case LONG: {
                        typeName = Items.ITEM_CANVAS_LONG.method_7864(class_1799.field_8037);
                        break;
                    }
                    case TALL: {
                        typeName = Items.ITEM_CANVAS_TALL.method_7864(class_1799.field_8037);
                        break;
                    }
                    case LARGE: {
                        typeName = Items.ITEM_CANVAS_LARGE.method_7864(class_1799.field_8037);
                    }
                }
                player.method_43496((class_2561)class_2561.method_43469((String)"xercapaint.import.fail.2", (Object[])new Object[]{typeName}).method_27692(class_124.field_1061));
                return;
            }
            if (!ItemPalette.isFull(offhand)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.fail.3").method_27692(class_124.field_1061));
                return;
            }
            itemStack = mainhand;
        }
        itemStack.method_57379(Items.CANVAS_VERSION, (Object)tag.method_10550("v"));
        itemStack.method_57379(Items.CANVAS_ID, (Object)canvasId);
        itemStack.method_57379(Items.CANVAS_PIXELS, Arrays.stream(tag.method_10561("pixels")).boxed().toList());
        itemStack.method_57379(Items.CANVAS_GENERATION, (Object)tag.method_10550("generation"));
        if (tag.method_10573("title", 8) && tag.method_10573("author", 8)) {
            itemStack.method_57379(Items.CANVAS_TITLE, (Object)tag.method_10558("title"));
            itemStack.method_57379(Items.CANVAS_AUTHOR, (Object)tag.method_10558("author"));
        }
        if (doAddItem) {
            player.method_7270(itemStack);
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"xercapaint.import.success").method_27692(class_124.field_1060));
    }
}

