/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.PaletteUtil;
import xerca.xercapaint.SoundEvents;
import xerca.xercapaint.client.BasePalette;
import xerca.xercapaint.client.BrushSound;
import xerca.xercapaint.entity.EntityEasel;
import xerca.xercapaint.item.Items;
import xerca.xercapaint.packets.CanvasMiniUpdatePacket;
import xerca.xercapaint.packets.CanvasUpdatePacket;
import xerca.xercapaint.packets.EaselLeftPacket;
import xerca.xercapaint.packets.PaletteUpdatePacket;

@Environment(value=EnvType.CLIENT)
public class GuiCanvasEdit
extends BasePalette {
    private double canvasX;
    private double canvasY;
    private static final double[] canvasXs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private static final double[] canvasYs = new double[]{-1000.0, -1000.0, -1000.0, -1000.0};
    private final int canvasWidth;
    private final int canvasHeight;
    private int brushMeterX;
    private int brushMeterY;
    private int brushOpacityMeterX;
    private int brushOpacityMeterY;
    private final int canvasPixelScale;
    private final int canvasPixelWidth;
    private final int canvasPixelHeight;
    private int brushSize = 0;
    private boolean touchedCanvas = false;
    private boolean undoStarted = false;
    private boolean gettingSigned;
    private boolean isCarryingCanvas;
    private class_4185 buttonSign;
    private class_4185 buttonCancel;
    private class_4185 buttonFinalize;
    private int updateCount = 0;
    private BrushSound brushSound = null;
    private final int canvasHolderHeight = 10;
    private static int brushOpacitySetting = 0;
    private static final float[] brushOpacities = new float[]{1.0f, 0.75f, 0.5f, 0.25f};
    private static boolean showHelp = false;
    private final Set<Integer> draggedPoints = new HashSet<Integer>();
    private final class_1657 editingPlayer;
    private final CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String canvasTitle = "";
    private String canvasId = "";
    private int version = 0;
    private final EntityEasel easel;
    private int timeSinceLastUpdate = 0;
    private boolean skippedUpdate = false;
    private static final class_241[] outlinePoss1 = new class_241[]{new class_241(0.0f, 199.0f), new class_241(12.0f, 199.0f), new class_241(34.0f, 199.0f), new class_241(76.0f, 199.0f)};
    private static final class_241[] outlinePoss2 = new class_241[]{new class_241(128.0f, 199.0f), new class_241(135.0f, 199.0f), new class_241(147.0f, 199.0f), new class_241(169.0f, 199.0f)};
    private static final int maxUndoLength = 16;
    private final Deque<int[]> undoStack = new ArrayDeque<int[]>(16);

    protected GuiCanvasEdit(class_1657 player, class_1799 canvasStack, class_1799 paletteStack, class_2561 title, CanvasType canvasType, EntityEasel easel) {
        super(title, paletteStack);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        this.easel = easel;
        this.editingPlayer = player;
        List stackPixels = (List)canvasStack.method_57824(Items.CANVAS_PIXELS);
        String canvasId = (String)canvasStack.method_57824(Items.CANVAS_ID);
        if (stackPixels != null && canvasId != null) {
            this.pixels = stackPixels.stream().mapToInt(i -> i).toArray();
            this.canvasId = canvasId;
            this.version = (Integer)canvasStack.method_57825(Items.CANVAS_VERSION, (Object)1);
            this.canvasTitle = (String)canvasStack.method_57825(Items.CANVAS_TITLE, (Object)"");
            this.isSigned = !this.canvasTitle.isEmpty();
        } else {
            this.pixels = new int[canvasPixelArea];
            Arrays.fill(this.pixels, basicColors[15].rgbVal());
            long secs = System.currentTimeMillis() / 1000L;
            this.canvasId = String.valueOf(player.method_5667()) + "_" + secs;
        }
    }

    public void method_25426() {
        if (this.field_22787 == null) {
            return;
        }
        this.canvasX = canvasXs[this.canvasType.ordinal()];
        this.canvasY = canvasYs[this.canvasType.ordinal()];
        this.paletteX = paletteXs[this.canvasType.ordinal()];
        this.paletteY = paletteYs[this.canvasType.ordinal()];
        if (this.canvasX == -1000.0 || this.canvasY == -1000.0 || this.paletteX == -1000.0 || this.paletteY == -1000.0) {
            this.resetPositions();
        }
        this.updateCanvasPos(0.0, 0.0);
        this.updatePalettePos(0.0, 0.0);
        class_1041 window = this.field_22787.method_22683();
        GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212994);
        int x = window.method_4486() - 120;
        int y = window.method_4502() - 30;
        this.buttonSign = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"canvas.signButton"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = true;
                this.resetPositions();
                this.updateButtons();
                GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212993);
            }
        }).method_46434(x, y, 98, 20).method_46431());
        this.buttonFinalize = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"canvas.finalizeButton"), button -> {
            if (!this.isSigned) {
                this.canvasDirty = true;
                this.isSigned = true;
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(null);
                }
            }
        }).method_46434((int)this.canvasX - 100, 100, 98, 20).method_46431());
        this.buttonCancel = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
            if (!this.isSigned) {
                this.gettingSigned = false;
                this.updateButtons();
                GLFW.glfwSetInputMode((long)window.method_4490(), (int)208897, (int)212994);
            }
        }).method_46434((int)this.canvasX - 100, 130, 98, 20).method_46431());
        x = (int)((double)window.method_4486() * 0.95) - 21;
        y = (int)((double)window.method_4502() * 0.05);
        this.method_37063((class_364)new ToggleHelpButton(x, y, 21, 21, 197, 0, 21, paletteTextures, 256, 256, button -> {
            showHelp = !showHelp;
        }, class_7919.method_47407((class_2561)class_2561.method_43470((String)"Toggle help tooltips"))));
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.buttonSign.field_22764 = !this.gettingSigned;
            this.buttonCancel.field_22764 = this.gettingSigned;
            this.buttonFinalize.field_22764 = this.gettingSigned;
            this.buttonFinalize.field_22763 = !this.canvasTitle.trim().isEmpty();
            this.buttonFinalize.method_46421((int)this.canvasX - 100);
            this.buttonCancel.method_46421((int)this.canvasX - 100);
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels[y * this.canvasPixelWidth + x];
    }

    private void setPixelAt(int x, int y, PaletteUtil.Color color, float opacity) {
        if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight && !this.draggedPoints.contains(y * this.canvasPixelWidth + x)) {
            this.draggedPoints.add(y * this.canvasPixelWidth + x);
            this.pixels[y * this.canvasPixelWidth + x] = PaletteUtil.Color.mix(color, new PaletteUtil.Color(this.pixels[y * this.canvasPixelWidth + x]), opacity).rgbVal();
        }
    }

    private void setPixelsAt(int mouseX, int mouseY, PaletteUtil.Color color, int brushSize, float opacity) {
        int pixelHalf = this.canvasPixelScale / 2;
        switch (brushSize) {
            case 0: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                break;
            }
            case 1: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                break;
            }
            case 2: {
                int x = (mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x, y - 2, color, opacity);
                break;
            }
            case 3: {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                this.setPixelAt(x - 1, y + 2, color, opacity);
                this.setPixelAt(x + 0, y + 2, color, opacity);
                this.setPixelAt(x + 1, y + 2, color, opacity);
                this.setPixelAt(x - 2, y + 1, color, opacity);
                this.setPixelAt(x - 1, y + 1, color, opacity);
                this.setPixelAt(x + 0, y + 1, color, opacity);
                this.setPixelAt(x + 1, y + 1, color, opacity);
                this.setPixelAt(x + 2, y + 1, color, opacity);
                this.setPixelAt(x - 2, y, color, opacity);
                this.setPixelAt(x - 1, y, color, opacity);
                this.setPixelAt(x + 0, y, color, opacity);
                this.setPixelAt(x + 1, y, color, opacity);
                this.setPixelAt(x + 2, y, color, opacity);
                this.setPixelAt(x - 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 1, color, opacity);
                this.setPixelAt(x + 0, y - 1, color, opacity);
                this.setPixelAt(x + 1, y - 1, color, opacity);
                this.setPixelAt(x + 2, y - 1, color, opacity);
                this.setPixelAt(x - 1, y - 2, color, opacity);
                this.setPixelAt(x + 0, y - 2, color, opacity);
                this.setPixelAt(x + 1, y - 2, color, opacity);
            }
        }
    }

    private void resetPositions() {
        int padding = 40;
        int paletteCanvasX = (this.field_22789 - (157 + this.canvasWidth + 40)) / 2;
        this.canvasX = paletteCanvasX + 157 + 40;
        this.canvasY = this.canvasType.equals((Object)CanvasType.LONG) ? 80.0 : 40.0;
        this.paletteX = paletteCanvasX;
        this.paletteY = 40.0;
    }

    public void method_25393() {
        ++this.updateCount;
        ++this.timeSinceLastUpdate;
        if (this.easel != null) {
            if (this.easel.getItem().method_7960() || this.easel.method_31481() || this.easel.method_5858((class_1297)this.editingPlayer) > 64.0) {
                this.method_25419();
            }
            if (this.skippedUpdate && this.timeSinceLastUpdate > 20 && this.canvasDirty) {
                this.updateCanvas(false);
                this.skippedUpdate = false;
            }
        }
        super.method_25393();
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float f) {
        int i;
        if (!this.gettingSigned) {
            super.method_25394(guiGraphics, mouseX, mouseY, f);
        } else {
            super.superRender(guiGraphics, mouseX, mouseY, f);
        }
        guiGraphics.method_25294((int)(this.canvasX + (double)this.canvasWidth * 0.25), (int)this.canvasY - 10, (int)(this.canvasX + (double)this.canvasWidth * 0.75), (int)this.canvasY, -1973791);
        for (i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int y = (int)this.canvasY + i * this.canvasPixelScale;
                int x = (int)this.canvasX + j * this.canvasPixelScale;
                guiGraphics.method_25294(x, y, x + this.canvasPixelScale, y + this.canvasPixelScale, this.getPixelAt(j, i));
            }
        }
        if (!this.gettingSigned) {
            for (i = 0; i < 4; ++i) {
                int y = this.brushMeterY + i * 9;
                guiGraphics.method_25294(this.brushMeterX, y, this.brushMeterX + 3, y + 3, currentColor.rgbVal());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25302(paletteTextures, this.brushMeterX, this.brushMeterY + (3 - this.brushSize) * 9, 15, 246, 10, 10);
            guiGraphics.method_25302(paletteTextures, this.brushMeterX, this.brushMeterY, 0, 220, 9, 36);
            guiGraphics.method_25302(paletteTextures, this.brushOpacityMeterX, this.brushOpacityMeterY, 196, 197, 14, 59);
            guiGraphics.method_25302(paletteTextures, this.brushOpacityMeterX - 1, this.brushOpacityMeterY - 1 + brushOpacitySetting * 15, 212, 240, 16, 16);
            this.renderCursor(guiGraphics, mouseX, mouseY);
            if (showHelp) {
                if (this.inBrushMeter(mouseX, mouseY)) {
                    int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
                    if (selectedSize <= 3 && selectedSize >= 0) {
                        guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("Brush size (" + (selectedSize + 1) + ")")), mouseX, mouseY);
                    }
                } else if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                    int relativeY = mouseY - this.brushOpacityMeterY;
                    int selectedOpacity = relativeY / 15;
                    if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                        int percentage = 100 - 25 * selectedOpacity;
                        guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("Brush opacity (" + percentage + "%)")), mouseX, mouseY);
                    }
                } else if (this.inColorPicker(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    guiGraphics.method_51434(this.field_22793, Arrays.asList(class_2561.method_43470((String)"Color picker"), class_2561.method_43470((String)"Select the tool, then pick up a color from the canvas and drag-and-drop it to a custom color slot.").method_27692(class_124.field_1080)), mouseX, mouseY);
                } else if (this.inWater(mouseX - (int)this.paletteX, mouseY - (int)this.paletteY)) {
                    guiGraphics.method_51434(this.field_22793, Arrays.asList(class_2561.method_43470((String)"Color remover"), class_2561.method_43470((String)"Pick up some water and drag-and-drop it to a custom color slot to clear it.").method_27692(class_124.field_1080)), mouseX, mouseY);
                } else if (this.inCanvasHolder(mouseX, mouseY)) {
                    guiGraphics.method_51434(this.field_22793, Arrays.asList(class_2561.method_43470((String)"Canvas holder"), class_2561.method_43470((String)"Pick up the canvas and move it wherever you want. You can move the palette in the same way.").method_27692(class_124.field_1080)), mouseX, mouseY);
                }
            }
        } else {
            this.drawSigning(guiGraphics);
        }
    }

    private void renderCursor(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isCarryingColor) {
            this.carriedColor.setGLColor();
            guiGraphics.method_25302(paletteTextures, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isCarryingWater) {
            waterColor.setGLColor();
            guiGraphics.method_25302(paletteTextures, mouseX - 4, mouseY - 4, 9, 247, 6, 9);
        } else if (this.isPickingColor) {
            this.drawOutline(guiGraphics, mouseX, mouseY, 0);
            PaletteUtil.Color.WHITE.setGLColor();
            guiGraphics.method_25302(paletteTextures, mouseX, mouseY - 14, 25, 242, 14, 14);
        } else {
            this.drawOutline(guiGraphics, mouseX, mouseY, this.brushSize);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25294(mouseX, mouseY, mouseX + 3, mouseY + 3, currentColor.rgbVal());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int trueBrushY = 247 - 9 * this.brushSize;
            guiGraphics.method_25302(paletteTextures, mouseX, mouseY, 0, trueBrushY, 9, 9);
        }
    }

    private void drawOutline(@NotNull class_332 guiGraphics, int mouseX, int mouseY, int brushSize) {
        if (this.inCanvas(mouseX, mouseY)) {
            int x = 0;
            int y = 0;
            int outlineSize = 0;
            int pixelHalf = this.canvasPixelScale / 2;
            if (brushSize == 0) {
                x = (mouseX - (int)this.canvasX) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasX - 1;
                y = (mouseY - (int)this.canvasY) / this.canvasPixelScale * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale + 2;
            }
            if (brushSize == 1) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 1) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 2 + 2;
            }
            if (brushSize == 2) {
                x = ((mouseX - (int)this.canvasX + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY + pixelHalf) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 4 + 2;
            }
            if (brushSize == 3) {
                x = ((mouseX - (int)this.canvasX) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasX - 1;
                y = ((mouseY - (int)this.canvasY) / this.canvasPixelScale - 2) * this.canvasPixelScale + (int)this.canvasY - 1;
                outlineSize = this.canvasPixelScale * 5 + 2;
            }
            class_241 textureVec = this.canvasPixelScale == 10 ? outlinePoss1[brushSize] : outlinePoss2[brushSize];
            RenderSystem.setShaderColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            guiGraphics.method_25302(paletteTextures, x, y, (int)textureVec.field_1343, (int)textureVec.field_1342, outlineSize, outlineSize);
        }
    }

    private void drawSigning(@NotNull class_332 guiGraphics) {
        int i = (int)this.canvasX;
        int j = (int)this.canvasY;
        guiGraphics.method_25294(i + 10, j + 10, i + 150, j + 150, -1118482);
        Object s = this.canvasTitle;
        if (!this.isSigned) {
            s = this.updateCount / 6 % 2 == 0 ? (String)s + String.valueOf(class_124.field_1074) + "_" : (String)s + String.valueOf(class_124.field_1080) + "_";
        }
        String s1 = class_1074.method_4662((String)"canvas.editTitle", (Object[])new Object[0]);
        int k = this.field_22793.method_1727(s1);
        guiGraphics.method_51433(this.field_22793, s1, (int)((float)(i + 26) + (float)(116 - k) / 2.0f), j + 16 + 16, 0, false);
        int l = this.field_22793.method_1727((String)s);
        guiGraphics.method_51433(this.field_22793, (String)s, (int)((float)(i + 26) + (float)(116 - l) / 2.0f), j + 48, 0, false);
        String s2 = class_1074.method_4662((String)"canvas.byAuthor", (Object[])new Object[]{this.editingPlayer.method_5477().getString()});
        int i1 = this.field_22793.method_1727(s2);
        guiGraphics.method_51433(this.field_22793, String.valueOf(class_124.field_1063) + s2, (int)((float)(i + 26) + (float)(116 - i1) / 2.0f), j + 48 + 10, 0, false);
        guiGraphics.method_51440(this.field_22793, (class_5348)class_2561.method_43471((String)"canvas.finalizeWarning"), i + 26, j + 80, 116, 0);
    }

    private void playBrushSound() {
        this.brushSound = new BrushSound();
        this.playSound((class_1113)this.brushSound);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.gettingSigned) {
            switch (keyCode) {
                case 259: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasTitle = this.canvasTitle.substring(0, this.canvasTitle.length() - 1);
                    this.updateButtons();
                    break;
                }
                case 257: {
                    if (this.canvasTitle.isEmpty()) break;
                    this.canvasDirty = true;
                    this.isSigned = true;
                    if (this.field_22787 == null) break;
                    this.field_22787.method_1507(null);
                    break;
                }
            }
            return true;
        }
        if (keyCode == 90 && (modifiers & 2) == 2) {
            if (!this.undoStack.isEmpty()) {
                this.pixels = this.undoStack.pop();
                this.canvasDirty = true;
                if (this.easel != null) {
                    this.updateCanvas(false);
                }
            }
            return true;
        }
        if (keyCode == 79 && ++brushOpacitySetting >= 4) {
            brushOpacitySetting = 0;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private static boolean isAllowedChatCharacter(char var0) {
        return var0 != '\u00a7' && var0 >= ' ' && var0 != '\u007f';
    }

    public boolean method_25400(char typedChar, int something) {
        super.method_25400(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.canvasTitle.length() < 16 && GuiCanvasEdit.isAllowedChatCharacter(typedChar)) {
                this.canvasTitle = this.canvasTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double posX, double posY, double scrollX, double scrollY) {
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        if (!this.gettingSigned && scrollY != 0.0) {
            if (this.inBrushOpacityMeter(mouseX, mouseY)) {
                int maxBrushOpacity = 3;
                if ((brushOpacitySetting += scrollY < 0.0 ? 1 : -1) > 3) {
                    brushOpacitySetting = 0;
                } else if (brushOpacitySetting < 0) {
                    brushOpacitySetting = 3;
                }
                return true;
            }
            int maxBrushSize = 3;
            this.brushSize += scrollY > 0.0 ? 1 : -1;
            if (this.brushSize > 3) {
                this.brushSize = 0;
            } else if (this.brushSize < 0) {
                this.brushSize = 3;
            }
            return true;
        }
        return super.method_25401(posX, posY, scrollX, scrollY);
    }

    @Override
    public boolean method_25402(double posX, double posY, int mouseButton) {
        if (this.gettingSigned) {
            return super.superMouseClicked(posX, posY, mouseButton);
        }
        int mouseX = (int)Math.floor(posX);
        int mouseY = (int)Math.floor(posY);
        this.undoStarted = true;
        this.touchedCanvas = false;
        if (this.undoStack.size() >= 16) {
            this.undoStack.removeLast();
        }
        this.undoStack.push((int[])this.pixels.clone());
        if (this.inCanvas(mouseX, mouseY)) {
            if (this.isPickingColor) {
                int x = (mouseX - (int)this.canvasX) / this.canvasPixelScale;
                int y = (mouseY - (int)this.canvasY) / this.canvasPixelScale;
                if (x >= 0 && y >= 0 && x < this.canvasPixelWidth && y < this.canvasPixelHeight) {
                    int color = this.getPixelAt(x, y);
                    this.carriedColor = new PaletteUtil.Color(color);
                    this.setCarryingColor();
                    this.playSound(SoundEvents.COLOR_PICKER_SUCK);
                }
            } else {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
                this.playBrushSound();
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushMeter(mouseX, mouseY)) {
            int selectedSize = 3 - (mouseY - this.brushMeterY) / 9;
            if (selectedSize <= 3 && selectedSize >= 0) {
                this.brushSize = selectedSize;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inBrushOpacityMeter(mouseX, mouseY)) {
            int relativeY = mouseY - this.brushOpacityMeterY;
            int selectedOpacity = relativeY / 15;
            if (selectedOpacity >= 0 && selectedOpacity <= 3) {
                brushOpacitySetting = selectedOpacity;
            }
            return super.superMouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.inCanvasHolder(mouseX, mouseY)) {
            this.isCarryingCanvas = true;
        }
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    private void clickedCanvas(int mouseX, int mouseY, int mouseButton) {
        this.touchedCanvas = true;
        if (mouseButton == 0) {
            this.setPixelsAt(mouseX, mouseY, currentColor, this.brushSize, brushOpacities[brushOpacitySetting]);
        } else if (mouseButton == 1) {
            this.setPixelsAt(mouseX, mouseY, PaletteUtil.Color.WHITE, this.brushSize, 1.0f);
        }
        this.canvasDirty = true;
    }

    @Override
    public boolean method_25406(double posX, double posY, int mouseButton) {
        this.isCarryingCanvas = false;
        if (this.gettingSigned) {
            return super.superMouseReleased(posX, posY, mouseButton);
        }
        this.draggedPoints.clear();
        if (this.undoStarted && !this.touchedCanvas) {
            this.undoStarted = false;
            this.undoStack.removeFirst();
        }
        if (this.brushSound != null) {
            this.brushSound.stopSound();
        }
        if (this.easel != null) {
            this.updateCanvas(false);
        }
        return super.method_25406(posX, posY, mouseButton);
    }

    @Override
    public boolean method_25403(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        if (this.gettingSigned) {
            return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
        }
        if (!(this.isCarryingColor || this.isCarryingWater || this.isPickingColor || this.isCarryingPalette || this.isCarryingCanvas)) {
            int mouseY;
            int mouseX = (int)Math.floor(posX);
            if (this.inCanvas(mouseX, mouseY = (int)Math.floor(posY))) {
                this.clickedCanvas(mouseX, mouseY, mouseButton);
            }
            if (this.brushSound != null) {
                this.brushSound.refreshFade();
            }
        } else {
            if (this.isCarryingCanvas) {
                this.updateCanvasPos(deltaX, deltaY);
                return super.superMouseDragged(posX, posY, mouseButton, deltaX, deltaY);
            }
            if (this.isCarryingPalette) {
                boolean ret = super.method_25403(posX, posY, mouseButton, deltaX, deltaY);
                this.updatePalettePos(deltaX, deltaY);
                return ret;
            }
        }
        return super.method_25403(posX, posY, mouseButton, deltaX, deltaY);
    }

    private void updateCanvasPos(double deltaX, double deltaY) {
        this.canvasX += deltaX;
        this.canvasY += deltaY;
        this.brushMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushMeterY = (int)this.canvasY + this.canvasHeight / 2 + 30;
        this.brushOpacityMeterX = (int)this.canvasX + this.canvasWidth + 2;
        this.brushOpacityMeterY = (int)this.canvasY;
        GuiCanvasEdit.canvasXs[this.canvasType.ordinal()] = this.canvasX;
        GuiCanvasEdit.canvasYs[this.canvasType.ordinal()] = this.canvasY;
    }

    private void updatePalettePos(double deltaX, double deltaY) {
        this.paletteX += deltaX;
        this.paletteY += deltaY;
        GuiCanvasEdit.paletteXs[this.canvasType.ordinal()] = this.paletteX;
        GuiCanvasEdit.paletteYs[this.canvasType.ordinal()] = this.paletteY;
    }

    private boolean inCanvas(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth && (double)x >= this.canvasX && (double)y < this.canvasY + (double)this.canvasHeight && (double)y >= this.canvasY;
    }

    private boolean inCanvasHolder(int x, int y) {
        return (double)x < this.canvasX + (double)this.canvasWidth * 0.75 && (double)x >= this.canvasX + (double)this.canvasWidth * 0.25 && (double)y < this.canvasY && (double)y >= this.canvasY - 10.0;
    }

    private boolean inBrushMeter(int x, int y) {
        return x < this.brushMeterX + 9 && x >= this.brushMeterX && y < this.brushMeterY + 36 && y >= this.brushMeterY;
    }

    private boolean inBrushOpacityMeter(int x, int y) {
        return x < this.brushOpacityMeterX + 14 && x >= this.brushOpacityMeterX && y < this.brushOpacityMeterY + 56 + 3 && y >= this.brushOpacityMeterY;
    }

    public void method_25432() {
        this.updateCanvas(true);
    }

    private void updateCanvas(boolean closing) {
        if (closing) {
            if (this.canvasDirty) {
                ++this.version;
                int easelId = this.easel == null ? -1 : this.easel.method_5628();
                ClientPlayNetworking.send((class_8710)new CanvasUpdatePacket(this.pixels, this.isSigned, this.canvasTitle, this.canvasId, this.version, easelId, this.customColors, this.canvasType));
            } else {
                if (this.easel != null) {
                    ClientPlayNetworking.send((class_8710)new EaselLeftPacket(this.easel.method_5628()));
                }
                if (this.paletteDirty) {
                    PaletteUpdatePacket pack = new PaletteUpdatePacket(this.customColors);
                    ClientPlayNetworking.send((class_8710)pack);
                }
            }
        } else if (this.canvasDirty) {
            if (this.timeSinceLastUpdate < 10) {
                this.skippedUpdate = true;
            } else {
                ++this.version;
                ClientPlayNetworking.send((class_8710)new CanvasMiniUpdatePacket(this.pixels, this.canvasId, this.version, this.easel.method_5628(), this.canvasType));
                this.canvasDirty = false;
                this.timeSinceLastUpdate = 0;
            }
        }
    }

    public static class ToggleHelpButton
    extends class_4185 {
        protected final class_2960 resourceLocation;
        protected final int xTexStart;
        protected final int yTexStart;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;

        public ToggleHelpButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 texture, int texWidth, int texHeight, class_4185.class_4241 onClick, class_7919 tooltip) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), onClick, class_4185.field_40754);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
            this.method_47400(tooltip);
        }

        protected void postRender() {
            GlStateManager._enableDepthTest();
        }

        public void method_48579(@NotNull class_332 guiGraphics, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.resourceLocation);
            GlStateManager._disableDepthTest();
            int yTexStartNew = this.yTexStart;
            if (this.field_22762) {
                yTexStartNew += this.yDiffText;
            }
            int xTexStartNew = this.xTexStart + (showHelp ? 0 : this.field_22758);
            guiGraphics.method_25290(this.resourceLocation, this.method_46426(), this.method_46427(), (float)xTexStartNew, (float)yTexStartNew, this.field_22758, this.field_22759, this.texWidth, this.texHeight);
            this.postRender();
        }
    }
}

