/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.client.KeyBindings;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.client.model.ChoppedLogModelLoadingPlugin;
import ht.treechop.client.model.FabricChoppedLogBakedModel;
import ht.treechop.client.model.FabricChoppedLogEntityRenderer;
import ht.treechop.client.model.HiddenChoppedLogBakedModel;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.network.ServerConfirmSettingsPacket;
import ht.treechop.common.network.ServerPermissionsPacket;
import ht.treechop.common.network.ServerUpdateChopsPacket;
import ht.treechop.common.registry.FabricModBlocks;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class FabricClient
extends Client
implements ClientModInitializer {
    public void onInitializeClient() {
        if (FabricLoader.getInstance().isModLoaded("sodium") && !FabricLoader.getInstance().isModLoaded("indium")) {
            TreeChop.LOGGER.info("Sodium detected! Using alternative block renderer.");
            ConfigHandler.removeBarkOnInteriorLogs.override(false);
            ModelLoadingPlugin.register((ModelLoadingPlugin)new ChoppedLogModelLoadingPlugin(HiddenChoppedLogBakedModel::new));
            BlockEntityRendererRegistry.register(FabricModBlocks.CHOPPED_LOG_ENTITY, FabricChoppedLogEntityRenderer::new);
        } else {
            ModelLoadingPlugin.register((ModelLoadingPlugin)new ChoppedLogModelLoadingPlugin(FabricChoppedLogBakedModel::new));
            BlockRenderLayerMap.INSTANCE.putBlock(FabricModBlocks.CHOPPED_LOG, ChoppedLogBakedModel.RENDER_TYPE);
        }
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> FabricClient.syncOnJoin());
        this.registerPackets();
        this.registerKeybindings();
    }

    private void registerKeybindings() {
        KeyBindings.registerKeyMappings(KeyBindingHelper::registerKeyBinding);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (KeyBindings.ActionableKeyBinding keyBinding : KeyBindings.allKeyBindings) {
                if (!keyBinding.method_1436()) continue;
                keyBinding.onPress();
                return;
            }
        });
    }

    private void registerPackets() {
        ClientPlayNetworking.registerGlobalReceiver(ServerConfirmSettingsPacket.TYPE, (payload, context) -> payload.handle());
        ClientPlayNetworking.registerGlobalReceiver(ServerPermissionsPacket.TYPE, (payload, context) -> payload.handle());
        ClientPlayNetworking.registerGlobalReceiver(ServerUpdateChopsPacket.TYPE, (payload, context) -> payload.handle());
    }

    @Override
    void sendToServer(class_8710 payload) {
        ClientPlayNetworking.send((class_8710)payload);
    }

    static {
        Client.instance = new FabricClient();
    }
}

