/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature;

import com.github.thedeathlycow.thermoo.api.temperature.EmptyEnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class EnvironmentManager {
    public static final EnvironmentManager INSTANCE = new EnvironmentManager();
    @NotNull
    private EnvironmentController controller = this.createDefaultController();

    @NotNull
    public EnvironmentController getController() {
        return this.controller;
    }

    public void addController(Function<EnvironmentController, EnvironmentController> decorator) {
        this.controller = decorator.apply(this.controller);
    }

    @NotNull
    public EnvironmentController peelController() {
        EnvironmentController old = this.controller;
        EnvironmentController decorated = this.controller.getDecorated();
        if (decorated != null) {
            this.controller = decorated;
        }
        return old;
    }

    @Contract(value="->new")
    private EnvironmentController createDefaultController() {
        return new EmptyEnvironmentController();
    }

    public String toString() {
        return "EnvironmentManager{controller=" + String.valueOf(this.controller) + "}";
    }

    private EnvironmentManager() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Thermoo.LOGGER.info("Initializing environment controller...");
            INSTANCE.addController(((EnvironmentControllerInitializeEvent.Callback)EnvironmentControllerInitializeEvent.EVENT.invoker())::decorateController);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            Thermoo.LOGGER.info("Resetting environment controller...");
            this.controller = this.createDefaultController();
        });
    }
}

