/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature;

import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public enum HeatingModes implements HeatingMode,
class_3542
{
    ABSOLUTE("absolute"){

        @Override
        public int applyResistance(TemperatureAware target, int temperatureChange) {
            return temperatureChange;
        }
    }
    ,
    ACTIVE("active"){

        @Override
        public int applyResistance(TemperatureAware target, int temperatureChange) {
            boolean isChangeFreezing = temperatureChange < 0;
            double resistance = isChangeFreezing ? target.thermoo$getColdResistance() : target.thermoo$getHeatResistance();
            return HeatingModes.applyResistanceToDelta(resistance, temperatureChange);
        }
    }
    ,
    PASSIVE("passive"){

        @Override
        public int applyResistance(TemperatureAware target, int temperatureChange) {
            int currentTemperature = target.thermoo$getTemperature();
            boolean isChangeFreezing = temperatureChange < 0;
            double resistance = 0.0;
            if (currentTemperature < 0 && isChangeFreezing) {
                resistance = target.thermoo$getColdResistance();
            } else if (currentTemperature > 0 && !isChangeFreezing) {
                resistance = target.thermoo$getHeatResistance();
            }
            return HeatingModes.applyResistanceToDelta(resistance, temperatureChange);
        }
    };

    private final String id;

    private HeatingModes(String id) {
        this.id = id;
    }

    public String method_15434() {
        return this.id;
    }

    private static int applyResistanceToDelta(double resistance, int temperatureChange) {
        double resistanceAsPercent = resistance * 10.0 / 100.0;
        return class_3532.method_15384((double)((1.0 - resistanceAsPercent) * (double)temperatureChange));
    }
}

