/*
 * Decompiled with CFR 0.152.
 */
package nukeduck.armorchroma;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.class_918;
import nukeduck.armorchroma.ArmorChroma;
import nukeduck.armorchroma.EntityAttributeInstanceAccess;
import nukeduck.armorchroma.config.ArmorIcon;
import nukeduck.armorchroma.config.Util;

public class GuiArmor {
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"armorchroma", (String)"textures/gui/background.png");
    private static final int[] BG_COLORS = new int[]{3853055, 3925338, 0xFFFF00, 16751872, 15544832, 7418049};
    private static final int ROW_SPACING = 5;
    private static final int ARMOR_PER_ROW = 20;
    private static final class_5132 FALLBACK_ATTRIBUTES = class_5132.method_26861().method_26867(class_5134.field_23724).method_26866();
    private final class_310 client = class_310.method_1551();
    private int zOffset;

    public void draw(class_332 context, int left, int top) {
        LinkedHashMap<class_1304, Integer> pointsMap = new LinkedHashMap<class_1304, Integer>();
        int totalPoints = this.getArmorPoints(this.client.field_1724, pointsMap);
        if (totalPoints <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int barPoints = 0;
        int compressedRows = ArmorChroma.config.compressBar() ? this.compressRows(pointsMap, totalPoints) : 0;
        this.zOffset = -2;
        for (Map.Entry entry : pointsMap.entrySet()) {
            this.drawPiece(context, left, top, barPoints, (Integer)entry.getValue(), this.client.field_1724.method_6118((class_1304)entry.getKey()));
            barPoints += ((Integer)entry.getValue()).intValue();
        }
        this.drawBackground(context, left, top, compressedRows);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawBackground(class_332 context, int x, int y, int level) {
        boolean drawBorder;
        boolean bl = drawBorder = level > 0;
        if (ArmorChroma.config.renderBackground() || drawBorder) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25291(BACKGROUND, x, y, this.zOffset, 0.0f, 0.0f, 81, 9, 256, 256);
        }
        if (drawBorder) {
            int color = level <= BG_COLORS.length ? BG_COLORS[level - 1] : BG_COLORS[BG_COLORS.length - 1];
            Util.setColor(color);
            context.method_25291(BACKGROUND, x - 1, y - 1, this.zOffset, 81.0f, 0.0f, 83, 11, 256, 256);
        }
    }

    private void drawPiece(class_332 context, int left, int top, int barPoints, int stackPoints, class_1799 stack) {
        int space;
        top -= barPoints / 20 * 5;
        while ((space = 20 - barPoints % 20) <= stackPoints) {
            this.drawPartialRow(context, left, top, 20 - space, space, stack);
            this.zOffset -= 3;
            top -= 5;
            barPoints += space;
            stackPoints -= space;
        }
        if (stackPoints > 0) {
            this.drawPartialRow(context, left, top, 20 - space, stackPoints, stack);
            --this.zOffset;
        }
    }

    private void drawPartialRow(class_332 context, int left, int top, int barPoints, int stackPoints, class_1799 stack) {
        boolean glint;
        ArmorIcon icon = ArmorChroma.ICON_DATA.getIcon(stack);
        RenderSystem.setShaderTexture((int)0, (class_2960)icon.texture);
        boolean bl = glint = ArmorChroma.config.renderGlint() && stack.method_7958();
        if (glint) {
            this.zOffset += 2;
        }
        int i = barPoints & 1;
        int x = left + barPoints * 4;
        if (i == 1) {
            this.drawMaskedIcon(context, x - 4, top, icon, ArmorChroma.ICON_DATA.getSpecial(Util.getModid(stack), "leadingMask"));
            x += 4;
        }
        while (i < stackPoints - 1) {
            icon.draw(context, x, top, this.zOffset);
            i += 2;
            x += 8;
        }
        if (i < stackPoints) {
            this.drawMaskedIcon(context, x, top, icon, ArmorChroma.ICON_DATA.getSpecial(Util.getModid(stack), "trailingMask"));
        }
        if (glint) {
            this.drawTexturedGlintRect(context, left + barPoints * 4, top, left, 0.0f, stackPoints * 4 + 1, 9);
            this.zOffset -= 2;
        }
    }

    private int getArmorPoints(class_746 player, Map<class_1304, Integer> pointsMap) {
        class_5131 attributes = new class_5131(FALLBACK_ATTRIBUTES);
        class_1324 armor = attributes.method_45329(class_5134.field_23724);
        if (armor == null) {
            return 0;
        }
        int displayedArmorCap = ArmorChroma.config.getDisplayedArmorCap();
        int attrLast = (int)((EntityAttributeInstanceAccess)armor).getUnclampedValue();
        class_1304[] slots = class_1304.values();
        if (ArmorChroma.config.reverse()) {
            Util.reverse(slots);
        }
        for (class_1304 slot : slots) {
            player.method_6118(slot).method_57354(slot, (attribute, modifier) -> {
                if (attribute == class_5134.field_23724) {
                    armor.method_26835(modifier);
                }
            });
            int attrNext = Math.min(displayedArmorCap, (int)((EntityAttributeInstanceAccess)armor).getUnclampedValue());
            int points = attrNext - attrLast;
            attrLast = attrNext;
            if (points <= 0) continue;
            pointsMap.put(slot, points);
        }
        return attrLast;
    }

    private int compressRows(Map<class_1304, Integer> pointsMap, int totalPoints) {
        int d;
        int compressedRows = (totalPoints - 1) / 20;
        int compressedPoints = compressedRows * 20;
        Iterator<Map.Entry<class_1304, Integer>> it = pointsMap.entrySet().iterator();
        for (int i = 0; i < compressedPoints; i += d) {
            Map.Entry<class_1304, Integer> entry = it.next();
            d = Math.min(compressedPoints - i, entry.getValue());
            if (d == entry.getValue()) {
                it.remove();
                continue;
            }
            entry.setValue(entry.getValue() - d);
        }
        return compressedRows;
    }

    public void drawMaskedIcon(class_332 context, int x, int y, ArmorIcon icon, ArmorIcon mask) {
        mask.draw(context, x, y, this.zOffset);
        RenderSystem.depthFunc((int)514);
        RenderSystem.blendFunc((int)774, (int)0);
        icon.draw(context, x, y, this.zOffset);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.depthFunc((int)515);
    }

    public void drawTexturedGlintRect(class_332 context, int x, int y, float u, float v, int width, int height) {
        RenderSystem.depthFunc((int)514);
        RenderSystem.blendFuncSeparate((int)768, (int)1, (int)1, (int)0);
        float intensity = ((Double)this.client.field_1690.method_48581().method_41753()).floatValue() * ArmorChroma.config.glintIntensity();
        RenderSystem.setShaderColor((float)intensity, (float)intensity, (float)intensity, (float)1.0f);
        double glintSpeed = (Double)this.client.field_1690.method_48580().method_41753();
        long time = (long)((double)class_156.method_658() * glintSpeed * 8.0);
        context.method_25291(class_918.field_43087, x, y, this.zOffset, u += (float)(-(time % 110000L) * 256L) / 110000.0f + (float)x, v += (float)(time % 30000L * 256L) / 30000.0f + (float)y, width, height, 256, 256);
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

