/*
 * Decompiled with CFR 0.152.
 */
package nukeduck.armorchroma.config;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import nukeduck.armorchroma.ArmorChroma;
import nukeduck.armorchroma.config.ArmorIcon;
import nukeduck.armorchroma.config.IconTable;
import nukeduck.armorchroma.config.Util;

public class IconData
implements SimpleResourceReloadListener<Void> {
    private final Map<String, IconTable> mods = new HashMap<String, IconTable>();
    private static final ArmorIcon FALLBACK_ICON = new ArmorIcon(0);
    private static final String DEFAULT = "default";
    private static final String MINECRAFT = "minecraft";
    private static final class_2960 ID = class_2960.method_60655((String)"armorchroma", (String)"icondata");

    public class_2960 getFabricId() {
        return ID;
    }

    public ArmorIcon getIcon(class_1799 stack) {
        String modid = Util.getModid(stack);
        IconTable mod = this.mods.get(modid);
        Integer i = null;
        if (mod != null) {
            i = mod.getIconIndex(stack);
            if (i != null) {
                return new ArmorIcon(modid, i, Util.getColor(stack));
            }
            return this.getSpecial(modid, DEFAULT);
        }
        return this.getSpecial(MINECRAFT, DEFAULT);
    }

    public ArmorIcon getSpecial(String modid, String key) {
        IconTable mod = this.mods.get(modid);
        if (mod == null && (mod = this.mods.get(modid = MINECRAFT)) == null) {
            return FALLBACK_ICON;
        }
        Integer i = mod.getSpecialIndex(key);
        return i != null ? new ArmorIcon(modid, (int)i) : this.getSpecial(MINECRAFT, key);
    }

    public CompletableFuture<Void> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            this.mods.clear();
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                String modid = modContainer.getMetadata().getId();
                List resources = manager.method_14489(class_2960.method_60655((String)modid, (String)"textures/gui/armor_chroma.json"));
                if (!resources.isEmpty()) {
                    for (class_3298 resource : resources) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482()));){
                            IconTable mod = (IconTable)new Gson().fromJson((Reader)reader, IconTable.class);
                            this.mods.merge(modid, mod, (a, b) -> {
                                a.putAll((IconTable)b);
                                return a;
                            });
                        }
                        catch (JsonIOException | JsonSyntaxException | IOException e) {
                            ArmorChroma.LOGGER.error("[Armor Chroma] Error loading icons for {}", (Object)modid, (Object)e);
                        }
                    }
                    continue;
                }
                if (!MINECRAFT.equals(modid)) continue;
                throw new RuntimeException("Missing fallback icons. The mod is damaged");
            }
            IconTable minecraft = this.mods.get(MINECRAFT);
            if (minecraft == null || minecraft.getSpecialIndex(DEFAULT) == null || minecraft.getSpecialIndex("leadingMask") == null || minecraft.getSpecialIndex("trailingMask") == null) {
                throw new RuntimeException("Missing fallback icons. The mod is damaged");
            }
            ArmorChroma.LOGGER.info("[Armor Chroma] Loaded icons for {} mods", (Object)(this.mods.size() - 1));
            return null;
        });
    }

    public CompletableFuture<Void> apply(Void data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.completedFuture(null);
    }
}

