/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.Constants;
import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.init.SimpleHatsConfigAbstract;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6642;

public class BagItem
extends class_1792 {
    private HatEntry.HatSeason hatSeason = HatEntry.HatSeason.NONE;
    private boolean seasonal = false;
    private class_1814 rarity = class_1814.field_8906;
    private final List<HatItem> availableHatList = new ArrayList<HatItem>();
    private class_6642 availableHatListWeighted = null;

    public BagItem(class_1814 rarity) {
        super(new class_1792.class_1793().method_7894(rarity));
        this.rarity = rarity;
    }

    public BagItem(HatEntry.HatSeason hatSeason) {
        super(new class_1792.class_1793().method_7894(class_1814.field_8904));
        this.hatSeason = hatSeason;
        this.seasonal = true;
        this.rarity = class_1814.field_8904;
    }

    public static class_3414 getUnwrapFinishSound() {
        return (class_3414)class_3417.field_14883.comp_349();
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        player.method_5783(BagItem.getUnwrapFinishSound(), 1.0f, 1.0f + (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.4f);
        if (!level.method_8608()) {
            class_1792 item;
            if (!this.seasonal && HatEntry.HatSeason.getSeason() != HatEntry.HatSeason.NONE && level.method_8409().method_43057() * 100.0f < (float)SimpleHatsConfigAbstract.seasonalBagChance() && (item = BagItem.getSeasonalBag()) != class_1802.field_8162) {
                player.method_5706((class_1935)item);
            }
            if ((item = this.getBagResult(level, itemStack)) != class_1802.field_8162) {
                player.method_5706((class_1935)item);
            }
        }
        itemStack.method_7934(1);
        return class_1271.method_29237((Object)itemStack, (boolean)level.method_8608());
    }

    private static class_1792 getSeasonalBag() {
        switch (HatEntry.HatSeason.getSeason()) {
            case EASTER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagEaster();
            }
            case SUMMER: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagSummer();
            }
            case HALLOWEEN: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagHalloween();
            }
            case FESTIVE: {
                return SimpleHatsCommon.MOD_REGISTRY.getHatBagFestive();
            }
        }
        Constants.LOG.error("Failed to get seasonal bag type.");
        return class_1802.field_8162;
    }

    private class_1792 getBagResult(class_1937 level, class_1799 bagStack) {
        if (this.availableHatList.isEmpty()) {
            for (HatItem hat : SimpleHatsCommon.MOD_REGISTRY.getHatList()) {
                if (hat.getHatEntry().getHatRarity() != this.rarity && !this.seasonal || hat.getHatEntry().getHatWeight() == 0 || hat.getHatEntry().getHatSeason() != this.hatSeason) continue;
                this.availableHatList.add(hat);
            }
            if (this.availableHatList.isEmpty()) {
                Constants.LOG.error("Failed to populate " + String.valueOf(this.method_7864(bagStack)) + " loot list.");
                return class_1802.field_8162;
            }
        }
        if (this.availableHatListWeighted == null) {
            try {
                class_6005.class_6006<class_6017> builder = this.generateSimpleWeightedList((class_6005.class_6006<class_6017>)class_6005.method_34971().method_34975((Object)class_6016.method_34998((int)0), this.availableHatList.get(0).getHatEntry().getHatWeight()), 1);
                this.availableHatListWeighted = new class_6642(builder.method_34974());
            }
            catch (Exception ex) {
                Constants.LOG.error("Failed to generate " + String.valueOf(this.method_7864(bagStack)) + " weighted loot table: " + String.valueOf(ex));
                return class_1802.field_8162;
            }
        }
        return (class_1792)this.availableHatList.get(this.availableHatListWeighted.method_35008(level.method_8409()));
    }

    private class_6005.class_6006<class_6017> generateSimpleWeightedList(class_6005.class_6006<class_6017> list, int i) {
        if (i < this.availableHatList.size()) {
            list.method_34975((Object)class_6016.method_34998((int)i), this.availableHatList.get(i).getHatEntry().getHatWeight());
            list = this.generateSimpleWeightedList(list, ++i);
        }
        return list;
    }
}

