/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9793;
import net.minecraft.server.MinecraftServer;
import net.p3pp3rf1y.sophisticatedcore.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.PlayDiscPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.SoundHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StopDiscPlaybackPayload;

public class ServerStorageSoundHandler {
    private static final int KEEP_ALIVE_CHECK_INTERVAL = 10;
    private static final Map<class_5321<class_1937>, Long> lastWorldCheck = new HashMap<class_5321<class_1937>, Long>();
    private static final Map<class_5321<class_1937>, Map<UUID, KeepAliveInfo>> worldStorageSoundKeepAlive = new HashMap<class_5321<class_1937>, Map<UUID, KeepAliveInfo>>();
    private static final List<SoundHandler> soundHandlers = Lists.newArrayList();

    private ServerStorageSoundHandler() {
    }

    public static void registerSoundHandler(SoundHandler handler) {
        soundHandlers.add(handler);
    }

    public static void tick(class_3218 serverLevel) {
        if (serverLevel.method_8608()) {
            return;
        }
        class_5321 dim = serverLevel.method_27983();
        if (lastWorldCheck.computeIfAbsent((class_5321<class_1937>)dim, key -> serverLevel.method_8510()) > serverLevel.method_8510() - 10L || !worldStorageSoundKeepAlive.containsKey(dim)) {
            return;
        }
        lastWorldCheck.put((class_5321<class_1937>)dim, serverLevel.method_8510());
        worldStorageSoundKeepAlive.get(dim).entrySet().removeIf(entry -> {
            if (((KeepAliveInfo)entry.getValue()).getLastKeepAliveTime() < serverLevel.method_8510() - 10L) {
                ((KeepAliveInfo)entry.getValue()).getSoundHandler().stop((class_1937)serverLevel, ((KeepAliveInfo)entry.getValue()).getLastPosition(), (UUID)entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void updateKeepAlive(UUID storageUuid, class_1937 level, class_243 position, Runnable onNoLongerRunning) {
        class_5321 dim = level.method_27983();
        if (!worldStorageSoundKeepAlive.containsKey(dim) || !worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            onNoLongerRunning.run();
            return;
        }
        if (worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).get(storageUuid).update(level.method_8510(), position, storageUuid);
        }
    }

    public static void onSoundStopped(class_1937 level, UUID storageUuid) {
        ServerStorageSoundHandler.removeKeepAliveInfo(level, storageUuid);
    }

    private static void runSoundHandler(class_3218 serverWorld, class_243 position, UUID storageUuid, Runnable onStopHandler, Function<SoundHandler, Boolean> onHandler) {
        for (SoundHandler handler : Lists.reverse(soundHandlers)) {
            if (!onHandler.apply(handler).booleanValue()) continue;
            ServerStorageSoundHandler.putKeepAliveInfo(serverWorld, storageUuid, onStopHandler, position, handler);
            return;
        }
    }

    public static void startPlayingDisc(class_3218 serverLevel, class_2338 position, UUID storageUuid, class_1799 discItemStack, class_6880<class_9793> song, Runnable onStopHandler) {
        class_243 pos = class_243.method_24953((class_2382)position);
        ServerStorageSoundHandler.runSoundHandler(serverLevel, pos, storageUuid, onStopHandler, handler -> handler.play((class_1937)serverLevel, position, storageUuid, discItemStack, song));
    }

    public static void startPlayingDisc(class_3218 serverLevel, class_243 position, UUID storageUuid, int entityId, class_1799 discItemStack, class_6880<class_9793> song, Runnable onStopHandler) {
        ServerStorageSoundHandler.runSoundHandler(serverLevel, position, storageUuid, onStopHandler, handler -> handler.play((class_1937)serverLevel, position, storageUuid, entityId, discItemStack, song));
    }

    private static void putKeepAliveInfo(class_3218 serverLevel, UUID storageUuid, Runnable onStopHandler, class_243 pos, SoundHandler handler) {
        worldStorageSoundKeepAlive.computeIfAbsent((class_5321<class_1937>)serverLevel.method_27983(), dim -> new HashMap()).put(storageUuid, new KeepAliveInfo(onStopHandler, serverLevel.method_8510(), pos, handler));
    }

    public static void stopPlayingDisc(class_1937 level, class_243 position, UUID storageUuid) {
        class_5321 dim = level.method_27983();
        if (worldStorageSoundKeepAlive.containsKey(dim) && worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).get(storageUuid).getSoundHandler().stop(level, position, storageUuid);
        }
        ServerStorageSoundHandler.removeKeepAliveInfo(level, storageUuid);
    }

    private static void removeKeepAliveInfo(class_1937 level, UUID storageUuid) {
        class_5321 dim = level.method_27983();
        if (worldStorageSoundKeepAlive.containsKey(dim) && worldStorageSoundKeepAlive.get(dim).containsKey(storageUuid)) {
            worldStorageSoundKeepAlive.get(dim).remove(storageUuid).runOnStop();
        }
    }

    private static void sendStopMessage(class_1937 level, class_243 position, UUID storageUuid) {
        PacketDistributor.sendToAllNear(new StopDiscPlaybackPayload(storageUuid), level, position, 128);
    }

    public static void onWorldUnload(MinecraftServer server, class_3218 serverLevel) {
        worldStorageSoundKeepAlive.remove(serverLevel.method_27983());
        lastWorldCheck.remove(serverLevel.method_27983());
    }

    static {
        ServerStorageSoundHandler.registerSoundHandler(new SoundHandler(){

            @Override
            public boolean play(class_1937 level, class_2338 position, UUID storageUuid, class_1799 discItemStack, class_6880<class_9793> song) {
                PacketDistributor.sendToAllNear(new PlayDiscPayload(storageUuid, discItemStack, song, position), level, class_243.method_24953((class_2382)position), 128);
                return true;
            }

            @Override
            public boolean play(class_1937 level, class_243 position, UUID storageUuid, int entityId, class_1799 discItemStack, class_6880<class_9793> song) {
                PacketDistributor.sendToAllNear(new PlayDiscPayload(storageUuid, discItemStack, song, entityId), level, position, 128);
                return true;
            }

            @Override
            public void stop(class_1937 level, class_243 position, UUID storageUuid) {
                ServerStorageSoundHandler.sendStopMessage(level, position, storageUuid);
            }

            @Override
            public void update(UUID storageUuid, class_243 position) {
            }
        });
    }

    private static class KeepAliveInfo {
        private final WeakReference<Runnable> onStopHandler;
        private long lastKeepAliveTime;
        private class_243 lastPosition;
        private final SoundHandler handler;

        private KeepAliveInfo(Runnable onStopHandler, long lastKeepAliveTime, class_243 lastPosition, SoundHandler handler) {
            this.onStopHandler = new WeakReference<Runnable>(onStopHandler);
            this.lastKeepAliveTime = lastKeepAliveTime;
            this.lastPosition = lastPosition;
            this.handler = handler;
        }

        public long getLastKeepAliveTime() {
            return this.lastKeepAliveTime;
        }

        public class_243 getLastPosition() {
            return this.lastPosition;
        }

        public SoundHandler getSoundHandler() {
            return this.handler;
        }

        public void update(long gameTime, class_243 position, UUID storageUuid) {
            this.lastKeepAliveTime = gameTime;
            this.lastPosition = position;
            this.handler.update(storageUuid, position);
        }

        public void runOnStop() {
            Runnable handler = (Runnable)this.onStopHandler.get();
            if (handler != null) {
                handler.run();
            }
        }
    }
}

