/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigNotifiable;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import javax.annotation.Nullable;

public enum RendererToggle implements IHotkeyTogglable,
IConfigNotifiable<IConfigBoolean>
{
    OVERLAY_BEACON_RANGE("overlayBeaconRange", ""),
    OVERLAY_BIOME_BORDER("overlayBiomeBorder", ""),
    OVERLAY_BLOCK_GRID("overlayBlockGrid", ""),
    OVERLAY_CONDUIT_RANGE("overlayConduitRange", ""),
    OVERLAY_LIGHT_LEVEL("overlayLightLevel", ""),
    OVERLAY_RANDOM_TICKS_FIXED("overlayRandomTicksFixed", ""),
    OVERLAY_RANDOM_TICKS_PLAYER("overlayRandomTicksPlayer", ""),
    OVERLAY_REGION_FILE("overlayRegionFile", ""),
    OVERLAY_SLIME_CHUNKS_OVERLAY("overlaySlimeChunks", "", KeybindSettings.INGAME_BOTH),
    OVERLAY_SPAWNABLE_COLUMN_HEIGHTS("overlaySpawnableColumnHeights", ""),
    OVERLAY_SPAWN_CHUNK_OVERLAY_REAL("overlaySpawnChunkReal", ""),
    OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER("overlaySpawnChunkPlayer", ""),
    OVERLAY_STRUCTURE_MAIN_TOGGLE("overlayStructureMainToggle", true, ""),
    OVERLAY_VILLAGER_INFO("overlayVillagerInfo", true, ""),
    SHAPE_RENDERER("shapeRenderer", ""),
    DEBUG_DATA_MAIN_TOGGLE("debugDataMainToggle", true, ""),
    DEBUG_BEEDATA("debugBeeDataEnabled", true, ""),
    DEBUG_BRAIN("debugBrainEnabled", true, ""),
    DEBUG_BREEZE_JUMP("debugBreezeJumpEnabled", true, ""),
    DEBUG_CHUNK_BORDER("debugChunkBorder", ""),
    DEBUG_CHUNK_INFO("debugChunkInfo", ""),
    DEBUG_CHUNK_LOADING("debugChunkLoading", true, ""),
    DEBUG_CHUNK_OCCLUSION("debugChunkOcclusion", ""),
    DEBUG_COLLISION_BOXES("debugCollisionBoxEnabled", ""),
    DEBUG_HEIGHTMAP("debugHeightmapEnabled", ""),
    DEBUG_LIGHT("debugLightEnabled", ""),
    DEBUG_NEIGHBOR_UPDATES("debugNeighborsUpdateEnabled", true, ""),
    DEBUG_GAME_EVENT("debugGameEventsEnabled", true, ""),
    DEBUG_GOAL_SELECTOR("debugGoalSelectorEnabled", true, ""),
    DEBUG_PATH_FINDING("debugPathfindingEnabled", true, ""),
    DEBUG_RAID_CENTER("debugRaidCenterEnabled", true, ""),
    DEBUG_SKYLIGHT("debugSkylightEnabled", ""),
    DEBUG_SOLID_FACES("debugSolidFaceEnabled", ""),
    DEBUG_STRUCTURES("debugStructuresEnabled", true, ""),
    DEBUG_SUPPORTING_BLOCK("debugSupportingBlock", ""),
    DEBUG_WATER("debugWaterEnabled", ""),
    DEBUG_VILLAGE("debugVillageEnabled", true, ""),
    DEBUG_VILLAGE_SECTIONS("debugVillageSectionsEnabled", true, ""),
    DEBUG_WORLDGEN("debugWorldGenEnabled", true, "");

    public static final ImmutableList<RendererToggle> VALUES;
    private static final String RENDER_KEY = "minihud.config.render_toggle";
    private final String name;
    private String comment;
    private String prettyName;
    private String translatedName;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private boolean valueBoolean;
    private final boolean serverDataRequired;
    @Nullable
    private IValueChangeCallback<IConfigBoolean> callback;

    private RendererToggle(String name, String defaultHotkey) {
        this(name, false, defaultHotkey, KeybindSettings.DEFAULT, RendererToggle.buildTranslateName(name, "comment"), RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey) {
        this(name, serverDataRequired, defaultHotkey, KeybindSettings.DEFAULT, RendererToggle.buildTranslateName(name, "comment"), RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, String defaultHotkey, String comment) {
        this(name, false, defaultHotkey, KeybindSettings.DEFAULT, comment, RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, String comment) {
        this(name, serverDataRequired, defaultHotkey, KeybindSettings.DEFAULT, comment, RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, String defaultHotkey, String comment, String prettyName) {
        this(name, false, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, String comment, String prettyName) {
        this(name, serverDataRequired, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, String defaultHotkey, String comment, String prettyName, String translatedName) {
        this(name, false, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, translatedName);
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, String comment, String prettyName, String translatedName) {
        this(name, serverDataRequired, defaultHotkey, KeybindSettings.DEFAULT, comment, prettyName, translatedName);
    }

    private RendererToggle(String name, String defaultHotkey, KeybindSettings settings) {
        this(name, false, defaultHotkey, settings, RendererToggle.buildTranslateName(name, "comment"), RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings) {
        this(name, serverDataRequired, defaultHotkey, settings, RendererToggle.buildTranslateName(name, "comment"), RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, false, defaultHotkey, settings, comment, RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings, String comment) {
        this(name, serverDataRequired, defaultHotkey, settings, comment, RendererToggle.buildTranslateName(name, "prettyName"), RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this(name, false, defaultHotkey, settings, comment, prettyName, RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings, String comment, String prettyName) {
        this(name, serverDataRequired, defaultHotkey, settings, comment, prettyName, RendererToggle.buildTranslateName(name, "name"));
    }

    private RendererToggle(String name, boolean serverDataRequired, String defaultHotkey, KeybindSettings settings, String comment, String prettyName, String translatedName) {
        this.name = name;
        this.defaultValueBoolean = false;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback(this::toggleValueWithMessage);
        this.comment = comment;
        this.prettyName = prettyName;
        this.translatedName = translatedName;
        this.serverDataRequired = serverDataRequired;
    }

    private boolean toggleValueWithMessage(KeyAction action, IKeybind key) {
        InfoUtils.printBooleanConfigToggleMessage((String)this.getPrettyName(), (!this.valueBoolean ? 1 : 0) != 0);
        this.setBooleanValue(!this.valueBoolean);
        return true;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + this.name + GuiBase.TXT_RST;
        }
        return this.name;
    }

    public String getPrettyName() {
        return StringUtils.getTranslatedOrFallback((String)this.prettyName, (String)this.prettyName);
    }

    public String getConfigGuiDisplayName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public String getComment() {
        String comment = StringUtils.getTranslatedOrFallback((String)this.comment, (String)this.comment);
        if (comment != null && this.serverDataRequired) {
            return comment + "\n" + StringUtils.translate((String)"minihud.label.config_comment.server_side_data", (Object[])new Object[0]);
        }
        return comment;
    }

    public String getTranslatedName() {
        String name = StringUtils.getTranslatedOrFallback((String)this.translatedName, (String)this.name);
        if (this.serverDataRequired) {
            return GuiBase.TXT_GOLD + name + GuiBase.TXT_RST;
        }
        return name;
    }

    public void setPrettyName(String s) {
        this.prettyName = s;
    }

    public void setTranslatedName(String s) {
        this.translatedName = s;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        boolean oldValue = this.valueBoolean;
        this.valueBoolean = value;
        if (oldValue != this.valueBoolean) {
            this.onValueChanged();
        }
    }

    public void setValueChangeCallback(IValueChangeCallback<IConfigBoolean> callback) {
        this.callback = callback;
    }

    public void onValueChanged() {
        if (this.callback != null) {
            this.callback.onValueChanged((IConfigBase)this);
        }
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean needsServerData() {
        return this.serverDataRequired;
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return !String.valueOf(this.defaultValueBoolean).equals(newValue);
    }

    public void resetToDefault() {
        this.valueBoolean = this.defaultValueBoolean;
    }

    private static String buildTranslateName(String name, String type) {
        return "minihud.config.render_toggle." + type + "." + name;
    }

    public void setValueFromString(String value) {
        try {
            this.valueBoolean = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName());
            }
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])RendererToggle.values());
    }
}

