/*
 * Decompiled with CFR 0.152.
 */
package artifacts.config;

import artifacts.config.ConfigManager;
import java.util.function.Supplier;

public class GeneralConfig
extends ConfigManager {
    public final Supplier<Double> artifactRarity = this.defineNonNegativeDouble("artifactRarity", 1.0, "Affects how common artifacts are in chests", "Values above 1 will make artifacts rarer, values between 0 and 1 will make artifacts more common", "Doubling this value will make artifacts approximately twice as hard to find, and vice versa", "To prevent artifacts from appearing as chest loot, set this to 10000.");
    public final Supplier<Double> everlastingBeefChance = this.defineFraction("everlastingBeefChance", 0.002, "The chance everlasting beef drops when a cow or mooshroom is killed by a player");
    public final Supplier<Double> entityEquipmentChance = this.defineFraction("entityEquipmentChance", 0.0015, "The chance that a skeleton, zombie or piglin spawns with an artifact equipped");
    public final Supplier<Double> archaeologyChance = this.defineFraction("archaeologyChance", 0.0625, "The chance that an artifact generates in suspicious sand or gravel");
    public final Supplier<Boolean> modifyHurtSounds = this.defineBool("modifyHurtSounds", true, "Whether the Kitty Slippers and Bunny Hoppers change the player's hurt sounds");
    public final Campsite campsite = new Campsite();

    protected GeneralConfig() {
        super("general");
    }

    public class Campsite {
        public final Supplier<Integer> count;
        public final Supplier<Integer> minY;
        public final Supplier<Integer> maxY;
        public final Supplier<Double> mimicChance;
        public final Supplier<Boolean> useModdedChests;
        public final Supplier<Boolean> allowLightSources;

        public Campsite() {
            this.count = GeneralConfig.this.defineNonNegativeInt("campsite.campsiteCount", 40, "How many times a campsite will attempt to generate per chunk", "Set this to 0 to prevent campsites from generating");
            this.minY = GeneralConfig.this.defineInt("campsite.minY", -60, "The minimum height campsites can spawn at");
            this.maxY = GeneralConfig.this.defineInt("campsite.maxY", 40, "The maximum height campsites can spawn at");
            this.mimicChance = GeneralConfig.this.defineFraction("campsite.mimicChance", 0.3, "The probability that a campsite has a mimic instead of a chest");
            this.useModdedChests = GeneralConfig.this.defineBool("campsite.useModdedChests", true, "Whether to use wooden chests from other mods when generating campsites");
            this.allowLightSources = GeneralConfig.this.defineBool("campsite.allowLightSources", true, "Whether campsites can contain blocks that emit light");
        }
    }
}

