/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.fabric;

import java.util.List;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.CameraptureClient;
import me.chrr.camerapture.gui.AlbumLecternScreen;
import me.chrr.camerapture.gui.AlbumScreen;
import me.chrr.camerapture.gui.PictureFrameScreen;
import me.chrr.camerapture.gui.PictureScreen;
import me.chrr.camerapture.gui.UploadScreen;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.PictureTaker;
import me.chrr.camerapture.render.PictureFrameEntityRenderer;
import me.chrr.camerapture.render.PictureItemRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.event.client.player.ClientPreAttackCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;

public class CameraptureClientFabric
implements ClientModInitializer {
    public void onInitializeClient() {
        this.registerClientContent();
        this.registerClientEvents();
        CameraptureClient.registerPacketHandlers();
        CameraptureClient.init();
    }

    public void registerClientContent() {
        class_5272.method_27879((class_1792)Camerapture.PICTURE, (class_2960)Camerapture.id("should_render_picture"), (stack, world, entity, seed) -> PictureItemRenderer.canRender(stack) ? 1.0f : 0.0f);
        EntityRendererRegistry.register(Camerapture.PICTURE_FRAME, PictureFrameEntityRenderer::new);
        class_3929.method_17542(Camerapture.PICTURE_FRAME_SCREEN_HANDLER, PictureFrameScreen::new);
        class_3929.method_17542(Camerapture.ALBUM_SCREEN_HANDLER, AlbumScreen::new);
        class_3929.method_17542(Camerapture.ALBUM_LECTERN_SCREEN_HANDLER, AlbumLecternScreen::new);
    }

    public void registerClientEvents() {
        ClientPreAttackCallback.EVENT.register((client, player, clickCount) -> {
            CameraItem.HeldCamera camera = CameraItem.find((class_1657)player, true);
            if (camera == null) {
                return false;
            }
            if (CameraItem.canTakePicture((class_1657)player)) {
                PictureTaker.getInstance().takePicture();
            }
            return true;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            class_310 client = class_310.method_1551();
            if (!world.method_8608()) {
                return class_1271.method_22430((Object)stack);
            }
            if (client.field_1724 != player) {
                return class_1271.method_22430((Object)stack);
            }
            if (stack.method_31574(Camerapture.PICTURE)) {
                if (PictureItem.getPictureData(stack) != null) {
                    client.method_40000(() -> client.method_1507((class_437)new PictureScreen(List.of(stack))));
                    return class_1271.method_22427((Object)stack);
                }
            } else if (stack.method_31574(Camerapture.ALBUM) && !player.method_5715()) {
                List<class_1799> pictures = AlbumItem.getPictures(stack);
                if (!pictures.isEmpty()) {
                    client.method_40000(() -> client.method_1507((class_437)new PictureScreen(pictures)));
                    return class_1271.method_22427((Object)stack);
                }
            } else if (CameraItem.allowUploading && player.method_5715() && stack.method_31574(Camerapture.CAMERA) && !CameraItem.isActive(stack) && !player.method_7357().method_7904(Camerapture.CAMERA)) {
                client.method_40000(() -> client.method_1507((class_437)new UploadScreen()));
                return class_1271.method_22427((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ClientPictureStore.getInstance().clear();
            PictureTaker.getInstance().configureFromConfig();
            CameraItem.allowUploading = Camerapture.CONFIG_MANAGER.getConfig().server.allowUploading;
        });
    }
}

