/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_2826;
import net.minecraft.class_2841;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final class_2338.class_2339 recalcCenterPos = new class_2338.class_2339();
    protected final class_2338.class_2339 recalcNeighbourPos = new class_2338.class_2339();

    public BlockStarLightEngine(class_1937 world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(class_2791 chunk) {
        return ((ExtendedChunk)chunk).getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(class_2791 chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(class_2791 chunk) {
        return ((ExtendedChunk)chunk).getBlockNibbles();
    }

    @Override
    protected void setNibbles(class_2791 chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(class_2791 chunk) {
        return chunk.method_12009().method_12165(class_2806.field_12805) && (this.isClientSide || chunk.method_12038());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(class_2823 lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        class_2680 blockState = this.getBlockState(worldX, worldY, worldZ);
        int emittedLevel = blockState.method_26213() & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(class_2823 lightAccess, int worldX, int worldY, int worldZ, int expect) {
        Object conditionallyOpaqueState;
        class_2680 centerState = this.getBlockState(worldX, worldY, worldZ);
        int level = centerState.method_26213() & 0xF;
        if (level >= 14 || level > expect) {
            return level;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        int opacity = ((ExtendedAbstractBlockState)centerState).getOpacityIfCached();
        if (opacity == -1) {
            this.recalcCenterPos.method_10103(worldX, worldY, worldZ);
            opacity = centerState.method_26193(lightAccess.method_16399(), (class_2338)this.recalcCenterPos);
            conditionallyOpaqueState = ((ExtendedAbstractBlockState)centerState).isConditionallyFullOpaque() ? centerState : null;
        } else {
            if (opacity >= 15) {
                return level;
            }
            conditionallyOpaqueState = null;
        }
        opacity = Math.max(1, opacity);
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            class_2680 neighbourState = this.getBlockState(offX, offY, offZ);
            if (((ExtendedAbstractBlockState)neighbourState).isConditionallyFullOpaque()) {
                class_265 thisFace;
                this.recalcNeighbourPos.method_10103(offX, offY, offZ);
                class_265 neighbourFace = neighbourState.method_26173(lightAccess.method_16399(), (class_2338)this.recalcNeighbourPos, direction.opposite.nms);
                class_265 class_2652 = thisFace = conditionallyOpaqueState == null ? class_259.method_1073() : conditionallyOpaqueState.method_26173(lightAccess.method_16399(), (class_2338)this.recalcCenterPos, direction.nms);
                if (class_259.method_20713((class_265)thisFace, (class_265)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(class_2823 lightAccess, class_2791 atChunk, Set<class_2338> positions) {
        for (class_2338 pos : positions) {
            this.checkBlock(lightAccess, pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        this.performLightDecrease(lightAccess);
    }

    protected List<class_2338> getSources(class_2823 lightAccess, class_2791 chunk) {
        ArrayList<class_2338> sources = new ArrayList<class_2338>();
        int offX = chunk.method_12004().field_9181 << 4;
        int offZ = chunk.method_12004().field_9180 << 4;
        class_2826[] sections = chunk.method_12006();
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            class_2826 section = sections[sectionY - this.minSection];
            if (section == null || section.method_38292() || !section.method_19523(state -> state.method_26213() > 0)) continue;
            class_2841 states = section.field_12878;
            int offY = sectionY << 4;
            for (int index = 0; index < 4096; ++index) {
                class_2680 state2 = (class_2680)states.method_12331(index);
                if (state2.method_26213() <= 0) continue;
                sources.add(new class_2338(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
            }
        }
        return sources;
    }

    @Override
    public void lightChunk(class_2823 lightAccess, class_2791 chunk, boolean needsEdgeChecks) {
        int emittedMask = this.emittedLightMask;
        List<class_2338> positions = this.getSources(lightAccess, chunk);
        int len = positions.size();
        for (int i = 0; i < len; ++i) {
            class_2338 pos = positions.get(i);
            class_2680 blockState = this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
            int emittedLight = blockState.method_26213() & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
            this.appendToIncreaseQueue((long)(pos.method_10263() + (pos.method_10260() << 6) + (pos.method_10264() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.method_10263(), pos.method_10264(), pos.method_10260(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

