/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.VehicleEntity;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class OverlayRenderer {
    static final OverlayRenderer INSTANCE = new OverlayRenderer();
    private static final class_2960 ENGINE_TEX = Main.locate("textures/gui/engine.png");
    private static final class_2960 POWER_TEX = Main.locate("textures/gui/power.png");
    private static final class_2960 ICONS_TEX = Main.locate("textures/gui/icons.png");
    private float bootUp = 0.0f;
    private float lastTime = 0.0f;

    public static void renderOverlay(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        if (client.field_1761 != null && client.field_1724 != null) {
            class_1297 class_12972;
            if (Config.getInstance().showHotbarEngineGauge && (class_12972 = client.field_1724.method_5668()) instanceof EngineVehicle) {
                EngineVehicle aircraft = (EngineVehicle)class_12972;
                INSTANCE.renderAircraftGui(client, context, tickDelta, aircraft);
            }
            if ((class_12972 = client.field_1724.method_5668()) instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)class_12972;
                INSTANCE.renderAircraftHealth(client, context, vehicle);
            }
        }
    }

    private void renderAircraftHealth(class_310 minecraft, class_332 context, VehicleEntity vehicle) {
        int screenWidth = minecraft.method_22683().method_4486();
        int screenHeight = minecraft.method_22683().method_4502();
        int maxHearts = 10;
        int health = (int)Math.ceil(vehicle.getHealth() * (float)maxHearts * 2.0f);
        int y = screenHeight - 49 - Config.getInstance().healthBarRow * 10;
        int ox = screenWidth / 2 + 91;
        for (int i = 0; i < maxHearts; ++i) {
            int u = 52;
            int x = ox - i * 8 - 9;
            context.method_25290(ICONS_TEX, x, y, (float)u, 9.0f, 9, 9, 64, 64);
            if (i * 2 + 1 < health) {
                context.method_25290(ICONS_TEX, x, y, 0.0f, 0.0f, 9, 9, 64, 64);
            }
            if (i * 2 + 1 != health) continue;
            context.method_25290(ICONS_TEX, x, y, 10.0f, 0.0f, 9, 9, 64, 64);
        }
    }

    private void renderAircraftGui(class_310 client, class_332 context, float tickDelta, EngineVehicle aircraft) {
        assert (client.field_1687 != null);
        if (aircraft.getGuiStyle() == EngineVehicle.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.field_1687.method_8510() % 65536L) + tickDelta;
            float delta = time - this.lastTime;
            this.lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (this.bootUp < 1.0f) {
                    this.bootUp = Math.min(1.0f, this.bootUp + delta * 0.2f);
                    frame = (int)(this.bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * 30.0f);
                    frame = 5 + animation % 6;
                }
            } else if (this.bootUp > 0.0f) {
                this.bootUp = Math.max(0.0f, this.bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)this.bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.method_22683().method_4486() / 2;
            int y = client.method_22683().method_4502() - 37;
            if (client.field_1761 != null && !client.field_1761.method_2913()) {
                y += 7;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25290(ENGINE_TEX, x - 9, y - 9, (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.method_25290(POWER_TEX, x - 9, y - 9, (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.method_25290(POWER_TEX, x - 9, y - 9, (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), 18, 18, 90, 90);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

