/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.util.StringUtils;

public class ConfigString
extends ConfigBase<ConfigString>
implements IConfigValue {
    private final String defaultValue;
    private String value;
    private String previousValue;

    public ConfigString(String name, String defaultValue) {
        this(name, defaultValue, name + " Comment?", StringUtils.splitCamelCase(name), name);
    }

    public ConfigString(String name, String defaultValue, String comment) {
        this(name, defaultValue, comment, StringUtils.splitCamelCase(name), name);
    }

    public ConfigString(String name, String defaultValue, String comment, String prettyName) {
        this(name, defaultValue, comment, prettyName, name);
    }

    public ConfigString(String name, String defaultValue, String comment, String prettyName, String translatedName) {
        super(ConfigType.STRING, name, comment, prettyName, translatedName);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.previousValue = defaultValue;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public String getDefaultStringValue() {
        return this.defaultValue;
    }

    public String getOldStringValue() {
        return this.previousValue;
    }

    @Override
    public void setValueFromString(String value) {
        this.previousValue = this.value;
        this.value = value;
        if (!this.previousValue.equals(this.value)) {
            this.onValueChanged();
        }
    }

    @Override
    public void resetToDefault() {
        this.setValueFromString(this.defaultValue);
    }

    @Override
    public boolean isModified() {
        return !this.value.equals(this.defaultValue);
    }

    @Override
    public boolean isModified(String newValue) {
        return !this.defaultValue.equals(newValue);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.previousValue = this.value = element.getAsString();
            } else {
                MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(this.value);
    }
}

