/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.trimmable.tools.platform;

import dev.worldgen.trimmable.tools.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public Path getConfigFolder() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public List<Path> findPaths(String name) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            mod.findPath(name).ifPresent(paths::add);
        }
        return paths;
    }

    @Override
    public Map<String, Path> findFolders(String name) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            String modId = mod.getMetadata().getId();
            mod.findPath(name.formatted(modId)).ifPresent(path -> paths.put(modId, (Path)path));
        }
        return paths;
    }
}

