/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.network;

import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelz.access.LevelManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.init.CriteriaInit;
import net.levelz.level.LevelManager;
import net.levelz.level.PlayerSkill;
import net.levelz.level.Skill;
import net.levelz.network.packet.AttributeSyncPacket;
import net.levelz.network.packet.LevelPacket;
import net.levelz.network.packet.OrbPacket;
import net.levelz.network.packet.PlayerSkillSyncPacket;
import net.levelz.network.packet.RestrictionPacket;
import net.levelz.network.packet.SkillSyncPacket;
import net.levelz.network.packet.StatPacket;
import net.levelz.util.LevelHelper;
import net.levelz.util.PacketHelper;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2602;
import net.minecraft.class_2781;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_8710;
import net.minecraft.class_9145;

public class LevelServerPacket {
    public static final class_9145<OrbPacket> ADD_LEVEL_EXPERIENCE_ORB = LevelServerPacket.s2c("add_level_experience_orb");

    public static void init() {
        PayloadTypeRegistry.playS2C().register(SkillSyncPacket.PACKET_ID, SkillSyncPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(PlayerSkillSyncPacket.PACKET_ID, PlayerSkillSyncPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(LevelPacket.PACKET_ID, LevelPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(RestrictionPacket.PACKET_ID, RestrictionPacket.PACKET_CODEC);
        PayloadTypeRegistry.playS2C().register(StatPacket.PACKET_ID, StatPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(StatPacket.PACKET_ID, StatPacket.PACKET_CODEC);
        PayloadTypeRegistry.playC2S().register(AttributeSyncPacket.PACKET_ID, AttributeSyncPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(StatPacket.PACKET_ID, (payload, context) -> {
            int id = payload.id();
            int level = payload.level();
            context.server().execute(() -> {
                LevelManager levelManager = ((LevelManagerAccess)context.player()).getLevelManager();
                if (levelManager.getSkillPoints() - level >= 0) {
                    Skill skill = LevelManager.SKILLS.get(id);
                    PlayerSkill playerSkill = levelManager.getPlayerSkills().get(id);
                    if (ConfigInit.CONFIG.overallMaxLevel > 0 && ConfigInit.CONFIG.overallMaxLevel <= levelManager.getOverallLevel()) {
                        return;
                    }
                    if (!ConfigInit.CONFIG.allowHigherSkillLevel && playerSkill.getLevel() >= skill.getMaxLevel()) {
                        return;
                    }
                    for (int i = 1; i <= level; ++i) {
                        CriteriaInit.SKILL_UP.trigger(context.player(), skill.getKey(), playerSkill.getLevel() + level);
                    }
                    levelManager.setSkillLevel(id, playerSkill.getLevel() + level);
                    levelManager.setSkillPoints(levelManager.getSkillPoints() - level);
                    LevelHelper.updateSkill(context.player(), skill);
                    PacketHelper.updateLevels(context.player());
                    ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new StatPacket(id, levelManager.getSkillLevel(id)));
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver(AttributeSyncPacket.PACKET_ID, (payload, context) -> context.server().execute(() -> context.player().field_13987.method_14364((class_2596)new class_2781(context.player().method_5628(), List.of(context.player().method_5996(class_5134.field_23721))))));
    }

    private static <T extends class_2596<class_2602>> class_9145<T> s2c(String id) {
        return new class_9145(class_2598.field_11942, class_2960.method_60656((String)id));
    }
}

