/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.event;

import com.branders.spawnermod.SpawnerMod;
import com.branders.spawnermod.config.ConfigValues;
import com.branders.spawnermod.item.SpawnerKey;
import com.branders.spawnermod.registry.ModRegistry;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1917;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9356;
import net.minecraft.class_9360;
import net.minecraft.class_9361;

public class EventHandler {
    public boolean onLootTablesLoaded(class_5321<class_52> key, class_52.class_53 tableBuilder, LootTableSource source, class_7225.class_7874 registries) {
        if (!source.isBuiltin()) {
            return true;
        }
        if (class_2246.field_10260.method_26162() != key) {
            return true;
        }
        class_55.class_56 pool = class_55.method_347().method_356(this.createSilkTouchCondition(registries)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_2246.field_10260));
        tableBuilder.method_336(pool);
        return true;
    }

    public boolean onBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 entity) {
        if (world.field_9236) {
            return true;
        }
        if (player.method_7337()) {
            return true;
        }
        if (world.method_8320(pos).method_26204() instanceof class_2496) {
            class_1799 stack = (class_1799)Iterables.get((Iterable)player.method_5877(), (int)0);
            if (this.checkSilkTouch(stack) && ConfigValues.get("disable_silk_touch") == 0) {
                if (ConfigValues.get("disable_egg_removal_from_spawner") == 0) {
                    this.dropMonsterEgg(pos, world);
                }
            } else {
                int size = 15 + world.field_9229.method_43048(15) + world.field_9229.method_43048(15);
                class_1303.method_31493((class_3218)((class_3218)world), (class_243)class_243.method_24953((class_2382)pos), (int)size);
            }
        }
        return true;
    }

    public class_1269 onBlockInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (player.method_5715() && FabricLoader.getInstance().isModLoaded("carrier")) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        if (world.method_8320(hitResult.method_17777()).method_26204() != class_2246.field_10260) {
            return class_1269.field_5811;
        }
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (ConfigValues.get("disable_egg_removal_from_spawner") != 0) {
            return class_1269.field_5811;
        }
        class_1792 item = player.method_6047().method_7909();
        if (item instanceof class_1747 || item instanceof class_1826 || item instanceof SpawnerKey) {
            return class_1269.field_5811;
        }
        String registryName = class_7923.field_41178.method_10221((Object)item).toString();
        if (ConfigValues.get("display_item_id_from_right_click_in_log") == 1) {
            SpawnerMod.LOGGER.info("Right clicked with item id: " + registryName);
        }
        if (ConfigValues.isItemIdBlacklisted(registryName)) {
            return class_1269.field_5811;
        }
        return this.dropMonsterEgg(hitResult.method_17777(), world);
    }

    private class_1269 dropMonsterEgg(class_2338 pos, class_1937 world) {
        class_2680 blockstate = world.method_8320(pos);
        class_2636 spawner = (class_2636)world.method_8321(pos);
        class_1917 logic = spawner.method_11390();
        class_2487 nbt = new class_2487();
        class_2520 spawnData = (nbt = logic.method_8272(nbt)).method_10580("SpawnData");
        if (spawnData == null) {
            return class_1269.field_5811;
        }
        String entityString = spawnData.method_10714();
        if (entityString.indexOf("\"") == -1) {
            return class_1269.field_5811;
        }
        entityString = entityString.substring(entityString.indexOf("\"") + 1);
        if ((entityString = entityString.substring(0, entityString.indexOf("\""))).contains("area_effect_cloud")) {
            return class_1269.field_5811;
        }
        String eggId = ModRegistry.getSpawnEggRegistryName(entityString);
        class_1792 egg = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)eggId));
        if (egg == null) {
            SpawnerMod.LOGGER.info("Could not find spawn egg for: " + entityString);
            return class_1269.field_5811;
        }
        class_1799 itemStack = new class_1799((class_1935)egg);
        double d0 = (double)(world.method_8409().method_43057() * 0.7f) + (double)0.15f;
        double d1 = (double)(world.method_8409().method_43057() * 0.7f) + (double)0.06f + 0.6;
        double d2 = (double)(world.method_8409().method_43057() * 0.7f) + (double)0.15f;
        class_1542 entityItem = new class_1542(world, (double)pos.method_10263() + d0, (double)pos.method_10264() + d1, (double)pos.method_10260() + d2, itemStack);
        entityItem.method_6988();
        world.method_8649((class_1297)entityItem);
        logic.method_8274(class_1299.field_6083, world, world.field_9229, pos);
        spawner.method_5431();
        world.method_8413(pos, blockstate, blockstate, 3);
        return class_1269.field_5812;
    }

    public static class_1792 getSpawnEgg(String entityString) {
        class_1792 egg = null;
        egg = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)(entityString + "_spawn_egg")));
        if (egg == class_1802.field_8162) {
            String[] split = entityString.split(":");
            assert (split.length == 2);
            String id = split[0];
            String e = "spawn_egg_" + split[1];
            egg = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)(id + ":" + e)));
        }
        return egg;
    }

    public static void updateNeighbor(class_2338 spawnerPos, class_1937 world) {
        class_2680 blockstate = world.method_8320(spawnerPos);
        if (!(world.method_8321(spawnerPos) instanceof class_2636)) {
            return;
        }
        class_2636 spawner = (class_2636)world.method_8321(spawnerPos);
        class_1917 logic = spawner.method_11390();
        class_2487 nbt = new class_2487();
        nbt = logic.method_8272(nbt);
        if (world.method_49803(spawnerPos)) {
            short value = nbt.method_10568("RequiredPlayerRange");
            if (nbt.method_10568("SpawnRange") > 4) {
                return;
            }
            nbt.method_10575("SpawnRange", value);
            nbt.method_10575("RequiredPlayerRange", (short)0);
        } else {
            short pr = nbt.method_10568("SpawnRange");
            if (pr <= 4) {
                return;
            }
            nbt.method_10575("RequiredPlayerRange", pr);
            nbt.method_10575("SpawnRange", (short)4);
        }
        logic.method_8280(world, spawnerPos, nbt);
        spawner.method_5431();
        world.method_8413(spawnerPos, blockstate, blockstate, 3);
    }

    private boolean checkSilkTouch(class_1799 stack) {
        List silkTouch = stack.method_58657().method_57539().stream().filter(entry -> {
            int level = class_1890.method_8225((class_6880)((class_6880)entry.getKey()), (class_1799)stack);
            return ((class_6880)entry.getKey()).method_40225(class_1893.field_9099) && level >= 1;
        }).collect(Collectors.toList());
        return silkTouch.size() >= 1;
    }

    public class_5341.class_210 createSilkTouchCondition(class_7225.class_7874 registries) {
        class_7225.class_7226 impl = registries.method_46762(class_7924.field_41265);
        return class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_58179(class_9361.field_49807, (class_9360)class_9356.method_58173(List.of(new class_2035((class_6880)impl.method_46747(class_1893.field_9099), class_2096.class_2100.method_9053((int)1))))));
    }
}

