/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.group.EnvironmentConfigGroup;
import com.github.thedeathlycow.frostiful.registry.tag.FBiomeTags;
import com.github.thedeathlycow.frostiful.registry.tag.SeasonalBiomeTags;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeason;
import java.util.function.ToIntFunction;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

public enum BiomeCategory {
    NORMAL(c -> 0, false),
    COLD_AT_NIGHT(c -> 0, true),
    COLD(EnvironmentConfigGroup::getColdBiomeTemperatureChange, true),
    FREEZING(EnvironmentConfigGroup::getFreezingBiomeTemperatureChange, true);

    private static final float SNOW_TEMPERATURE = 0.15f;
    private static final int NIGHT_TIME_SURFACE_LIGHT = 4;
    private final ToIntFunction<EnvironmentConfigGroup> temperatureChange;
    private final boolean coldAtNight;

    private BiomeCategory(ToIntFunction<EnvironmentConfigGroup> temperatureChange, boolean coldAtNight) {
        this.temperatureChange = temperatureChange;
        this.coldAtNight = coldAtNight;
    }

    public static BiomeCategory fromBiome(class_6880<class_1959> biomeEntry, ThermooSeason season) {
        class_1959 biome = (class_1959)biomeEntry.comp_349();
        EnvironmentConfigGroup config = Frostiful.getConfig().environmentConfig;
        float temperature = biome.method_8712();
        SeasonalBiomeTags tags = SeasonalBiomeTags.forSeason(season);
        BiomeCategory category = biomeEntry.method_40220(FBiomeTags.FREEZING_BLACKLIST_BIOMES) ? NORMAL : (biomeEntry.method_40220(tags.freezing()) ? FREEZING : (temperature <= 0.15f || biomeEntry.method_40220(tags.cold()) ? COLD : (biomeEntry.method_40220(tags.cool()) || biomeEntry.method_40220(FBiomeTags.DRY_BIOMES) && config.doDryBiomeNightFreezing() ? COLD_AT_NIGHT : NORMAL)));
        return category;
    }

    public int getTemperatureChange(class_1937 world, class_2338 pos) {
        EnvironmentConfigGroup config = Frostiful.getConfig().environmentConfig;
        int change = this.temperatureChange.applyAsInt(config);
        int sunlight = world.method_8314(class_1944.field_9284, pos) - world.method_8594();
        if (this.coldAtNight && sunlight <= 4) {
            change += config.getNightTemperatureShift();
        }
        return change;
    }
}

