/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeInput;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_1163;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_4970;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public class BoilingWaterCauldronBlock
extends class_5556 {
    public static final MapCodec<BoilingWaterCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_1959.class_1963.field_46251.fieldOf("precipitation").forGetter(c -> c.precipitationType), (App)class_5620.field_46590.fieldOf("interactions").forGetter(c -> c.field_27084), (App)BoilingWaterCauldronBlock.method_54096()).apply((Applicative)i, BoilingWaterCauldronBlock::new));
    public static final class_2746 BOILING = ModBlockProperties.BOILING;
    private final class_1959.class_1963 precipitationType;

    public BoilingWaterCauldronBlock(class_1959.class_1963 precipitationType, class_5620.class_8821 interactions, class_4970.class_2251 properties) {
        super(precipitationType, interactions, properties);
        this.precipitationType = precipitationType;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{BOILING});
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        super.method_9548(state, level, pos, entity);
        if (!level.field_9236 && this.method_31616(state, pos, entity)) {
            if (((Boolean)state.method_11654((class_2769)BOILING)).booleanValue() && entity instanceof class_1309) {
                entity.method_5643(new class_1282(ModRegistry.BOILING_DAMAGE.getHolder()), 1.0f);
            }
            if (entity.method_5809()) {
                LiquidCauldronBlock.playExtinguishSound(level, pos, entity);
            }
            this.attemptStewCrafting(state, level, pos, entity);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2680 s = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        if (direction == class_2350.field_11033) {
            boolean isFire = LiquidCauldronBlock.shouldBoil(neighborState, SoftFluidStack.of((class_6880)BuiltInSoftFluids.WATER), level, neighborPos);
            s = (class_2680)s.method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return s;
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (this.method_31616(state, pos, entity)) {
            if (!level.field_9236) {
                ModCauldronBlock.playSplashEffects(entity, this.method_31615(state));
            }
            super.method_9554(level, state, pos, entity, 0.0f);
        } else {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public static int getWaterColor(class_2680 state, class_1920 level, class_2338 pos, int i) {
        return i == 1 && level != null && pos != null ? class_1163.method_4961((class_1920)level, (class_2338)pos) : -1;
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        super.method_9496(state, level, pos, random);
        if (((Boolean)state.method_11654((class_2769)BOILING)).booleanValue()) {
            LiquidCauldronBlock.playBubblingAnimation(level, pos, this.method_31615(state), random, BoilingWaterCauldronBlock.getWaterColor(state, (class_1920)level, pos, 1), 0);
        }
    }

    private void attemptStewCrafting(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (!((Boolean)state.method_11654((class_2769)BOILING)).booleanValue() || !(entity instanceof class_1542) || entity.field_6012 % 10 != 0) {
            return;
        }
        List entities = level.method_18467(class_1542.class, new class_238((double)pos.method_10263() + 0.125, (double)((float)pos.method_10264() + 0.375f), (double)pos.method_10260() + 0.125, (double)pos.method_10263() + 0.875, (double)pos.method_10264() + this.method_31615(state), (double)pos.method_10260() + 0.875));
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (class_1542 e : entities) {
            class_1799 i = e.method_6983();
            for (int c = 0; c < i.method_7947(); ++c) {
                ingredients.add(i.method_46651(1));
            }
        }
        ingredients.add(class_1802.field_8428.method_7854());
        class_9694 container = CauldronRecipeInput.of(ingredients);
        List recipes = level.method_8433().method_17877(class_3956.field_17545, (class_9695)container, level);
        for (class_8786 r : recipes) {
            class_2680 newState;
            Pair fluid;
            class_1799 result = ((class_3955)r.comp_1933()).method_8116((class_9695)container, (class_7225.class_7874)level.method_30349());
            if (result.method_7960() || (fluid = SoftFluidStack.fromItem((class_1799)result)) == null || (newState = CauldronConversion.getNewState(pos, level, (SoftFluidStack)fluid.getFirst())) == null) continue;
            level.method_8501(pos, newState);
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
                int lev = (Integer)state.method_11654((class_2769)field_27206);
                int newLev = lev == 3 ? te.getSoftFluidTank().getCapacity() : lev;
                te.getSoftFluidTank().setFluid(((SoftFluidStack)fluid.getFirst()).copyWithCount(newLev));
                te.method_5431();
                level.method_33596(entity, (class_6880)class_5712.field_28733, pos);
                level.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 0.9f, 0.6f);
            }
            BoilingWaterCauldronBlock.clearUsedIngredients(entities, ingredients);
        }
    }

    private static void clearUsedIngredients(List<class_1542> entities, List<class_1799> ingredients) {
        for (class_1799 v : ingredients) {
            Iterator<class_1542> iter = entities.iterator();
            while (iter.hasNext()) {
                class_1542 e = iter.next();
                class_1799 itemEntityItem = e.method_6983();
                if (!class_1799.method_31577((class_1799)itemEntityItem, (class_1799)v)) continue;
                itemEntityItem.method_7934(1);
                if (!itemEntityItem.method_7960()) continue;
                e.method_31472();
                iter.remove();
            }
        }
    }
}

