/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.minecraft.class_9799;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class BufferAllocatorPool {
    private static final ReferenceList<class_9799> FREE = new ReferenceArrayList();
    private static final ReferenceList<class_9799> IN_USE = new ReferenceArrayList();
    private static final Reference2LongMap<class_9799> BUFFER_ALLOCATOR_ACCESS_TIME = new Reference2LongOpenHashMap();

    private BufferAllocatorPool() {
    }

    public static class_9799 borrowBufferAllocator() {
        class_9799 bufferAllocator;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            bufferAllocator = new class_9799(256);
        } else {
            bufferAllocator = (class_9799)FREE.removeFirst();
            if (bufferAllocator.field_52082 == 0L) {
                BUFFER_ALLOCATOR_ACCESS_TIME.removeLong((Object)bufferAllocator);
                bufferAllocator = new class_9799(256);
            }
        }
        IN_USE.add((Object)bufferAllocator);
        BUFFER_ALLOCATOR_ACCESS_TIME.put((Object)bufferAllocator, System.currentTimeMillis());
        return bufferAllocator;
    }

    public static void returnBufferAllocatorSafe(class_9799 bufferAllocator) {
        RenderSystem.assertOnRenderThread();
        if (!IN_USE.remove((Object)bufferAllocator)) {
            return;
        }
        bufferAllocator.method_60811();
        FREE.add((Object)bufferAllocator);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            ImmediatelyFast.LOGGER.warn(IN_USE.size() + " BufferAllocator(s) were not returned to the pool. Forcibly reclaiming them.");
            for (class_9799 bufferAllocator : IN_USE) {
                bufferAllocator.method_60811();
            }
            FREE.addAll(IN_USE);
            IN_USE.clear();
        }
        BUFFER_ALLOCATOR_ACCESS_TIME.reference2LongEntrySet().removeIf(entry -> {
            if (System.currentTimeMillis() - entry.getLongValue() > 60000L) {
                if (FREE.contains(entry.getKey())) {
                    FREE.remove(entry.getKey());
                    ((class_9799)entry.getKey()).close();
                }
                return true;
            }
            return false;
        });
    }
}

