/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.fabric;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadEmitter inner;
    private final class_1058 sprite;
    private final Matrix4f globalTransform;
    private final Matrix3f normalTransf;
    private final Consumer<class_777> quadConsumer;
    private int vertexIndex = -1;
    private boolean autoDirection = false;

    public static BakedQuadBuilder create(class_1058 sprite, @Nullable Matrix4f transformation, Consumer<class_777> quadConsumer) {
        return new BakedQuadBuilderImpl(sprite, transformation, quadConsumer);
    }

    private BakedQuadBuilderImpl(class_1058 sprite, @Nullable Matrix4f transform, Consumer<class_777> quadConsumer) {
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        this.inner = meshBuilder.getEmitter();
        this.globalTransform = transform;
        this.sprite = sprite;
        this.quadConsumer = quadConsumer;
        this.inner.spriteBake(sprite, 4);
        this.normalTransf = transform == null ? null : new Matrix3f((Matrix4fc)transform).invert().transpose();
    }

    @Override
    public BakedQuadBuilder setTint(int tintIndex) {
        this.inner.colorIndex(tintIndex);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAutoDirection() {
        this.autoDirection = true;
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setShade(boolean shade) {
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setAmbientOcclusion(boolean ambientOcclusion) {
        return this;
    }

    @Override
    public BakedQuadBuilderImpl setDirection(class_2350 direction) {
        if (this.globalTransform != null) {
            direction = class_2350.method_23225((Matrix4f)this.globalTransform, (class_2350)direction);
        }
        this.inner.nominalFace(direction);
        return this;
    }

    public BakedQuadBuilderImpl addVertex(float x, float y, float z) {
        this.tryBaking();
        ++this.vertexIndex;
        if (this.globalTransform != null) {
            Vector4f v = this.globalTransform.transform(new Vector4f(x, y, z, 1.0f));
            this.inner.pos(this.vertexIndex, v.x(), v.y(), v.z());
            return this;
        }
        this.inner.pos(this.vertexIndex, x, y, z);
        return this;
    }

    public BakedQuadBuilderImpl setNormal(float x, float y, float z) {
        if (this.globalTransform != null) {
            Vector3f normal = this.normalTransf.transform(new Vector3f(x, y, z));
            normal.normalize();
            this.inner.normal(this.vertexIndex, normal.x(), normal.y(), normal.z());
        } else {
            this.inner.normal(this.vertexIndex, x, y, z);
        }
        if (this.autoDirection) {
            this.setDirection(class_2350.method_10147((float)x, (float)y, (float)z));
        }
        return this;
    }

    public BakedQuadBuilderImpl setColor(int rgba) {
        this.inner.color(this.vertexIndex, rgba);
        return this;
    }

    public BakedQuadBuilderImpl setColor(int r, int g, int b, int a) {
        return this.setColor((a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF);
    }

    public BakedQuadBuilderImpl setUv(float u, float v) {
        this.inner.uv(this.vertexIndex, this.sprite.method_4580(u * 16.0f), this.sprite.method_4570(v * 16.0f));
        return this;
    }

    public BakedQuadBuilderImpl setUv1(int u, int v) {
        return this;
    }

    public BakedQuadBuilderImpl setUv2(int u, int v) {
        this.inner.lightmap(this.vertexIndex, u & 0xFFFF | (v & 0xFFFF) << 16);
        return this;
    }

    @Override
    public BakedQuadBuilderImpl lightEmission(int lightLevel) {
        this.inner.material(RendererAccess.INSTANCE.getRenderer().materialFinder().emissive(true).find());
        return this;
    }

    @Override
    public void close() {
        this.tryBaking();
    }

    private void tryBaking() {
        if (this.vertexIndex == 3) {
            this.vertexIndex = -1;
            Preconditions.checkNotNull((Object)this.sprite, (Object)"sprite cannot be null");
            this.quadConsumer.accept(this.inner.toBakedQuad(this.sprite));
        }
    }

    public BakedQuadBuilder fromVanilla(class_777 quad) {
        this.inner.fromVanilla(quad, RendererAccess.INSTANCE.getRenderer().materialFinder().find(), quad.method_3358());
        this.vertexIndex = 3;
        return this;
    }
}

