/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.integration.CompatWoodTypes;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.DynamicHolder;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ItemListingManager;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.network.ModNetworking;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Moonlight {
    public static final String MOD_ID = "moonlight";
    public static final Logger LOGGER = LogManager.getLogger((String)"Moonlight");
    public static final boolean HAS_BEEN_INIT = true;
    public static final ThreadLocal<Boolean> CAN_EARLY_RELOAD_HACK = ThreadLocal.withInitial(() -> true);
    public static final ThreadLocal<WeakReference<class_5455>> EARLY_REGISTRY_ACCESS = new ThreadLocal();
    private static final Set<String> DEPENDENTS = new HashSet<String>();

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        BlockSetInternal.registerBlockSetDefinition(WoodTypeRegistry.INSTANCE);
        BlockSetInternal.registerBlockSetDefinition(LeavesTypeRegistry.INSTANCE);
        CompatWoodTypes.init();
        MoonlightRegistry.init();
        ModNetworking.init();
        VillagerAIInternal.init();
        MapDataInternal.init();
        SoftFluidInternal.init();
        RegHelper.addDynamicDispenserBehaviorRegistration(Moonlight::registerBuiltinFluidBehavior);
        PlatHelper.addCommonSetup(Moonlight::commonSetup);
        PlatHelper.addReloadableCommonSetup(Moonlight::afterDataReload);
        PlatHelper.addServerReloadListener(ItemListingManager::new, Moonlight.res("villager_trade"));
        BlockSetAPI.addDynamicRegistration((reg, wood) -> AdditionalItemPlacementsAPI.afterItemReg(), WoodType.class, class_7923.field_41181);
        if (PlatHelper.getPhysicalSide().isClient()) {
            MoonlightClient.initClient();
        }
    }

    private static void commonSetup() {
        BlocksColorInternal.setup();
    }

    public static void onPlayerCloned(class_1657 oldPlayer, class_1657 newPlayer, boolean wasDeath) {
        if (wasDeath && !oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inv = oldPlayer.method_31548();
            int i = 0;
            for (class_1799 v : inv.field_7547) {
                if (v != class_1799.field_8037) {
                    IDropItemOnDeathEvent e = IDropItemOnDeathEvent.create(v, oldPlayer, false);
                    MoonlightEventsHelper.postEvent(e, IDropItemOnDeathEvent.class);
                    if (e.isCanceled()) {
                        newPlayer.method_31548().method_5447(i, e.getReturnItemStack());
                    }
                }
                ++i;
            }
        }
    }

    private static void afterDataReload(class_5455 registryAccess, boolean client) {
        EARLY_REGISTRY_ACCESS.set(new WeakReference<class_5455>(registryAccess));
        RegistryAccessJsonReloadListener.runReloads(registryAccess);
        DynamicResourcePack.clearAfterReload(class_3264.field_14190);
        DynamicHolder.clearCache();
        HolderReference.clearCache();
        DispenserHelper.reload(registryAccess, client);
    }

    public static void beforeServerStart(class_5455 ra) {
        SoftFluidInternal.doPostInitServer(ra);
    }

    public static void assertInitPhase() {
        if (!PlatHelper.isInitializing() && PlatHelper.getPlatform().isForge()) {
            throw new AssertionError((Object)"Method has to be called during main mod initialization phase. Client and Server initializer are not valid, you must call in the main one");
        }
    }

    @ApiStatus.Internal
    public static void addDependent(String modId) {
        if (!Set.of("minecraft", "neoforge", "fabric").contains(modId)) {
            DEPENDENTS.add(modId);
        }
    }

    public static Set<String> getDependents() {
        return Set.copyOf(DEPENDENTS);
    }

    public static boolean isDependant(String modId) {
        return DEPENDENTS.contains(modId);
    }

    public static void crashIfInDev(String message) {
        if (PlatHelper.isDev()) {
            throw new AssertionError();
        }
    }

    public static void crashIfInDev() {
        if (PlatHelper.isDev()) {
            throw new AssertionError();
        }
    }

    public static void logIfInDev(String s) {
        if (PlatHelper.isDev()) {
            LOGGER.error(s);
        }
    }

    public static void registerBuiltinFluidBehavior(DispenserHelper.Event event) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        for (SoftFluid f : SoftFluidRegistry.get(event.getRegistryAccess())) {
            List<FluidContainerList.Category> categories = f.getContainerList().getCategories();
            for (FluidContainerList.Category c : categories) {
                class_1792 empty = c.getEmptyContainer();
                if (empty != class_1802.field_8162 && !itemSet.contains(empty)) {
                    event.register(new DispenserHelper.FillFluidHolderBehavior(empty));
                    itemSet.add(empty);
                }
                for (class_1792 full : c.getFilledItems()) {
                    if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                    event.register(new DispenserHelper.FillFluidHolderBehavior(full));
                    itemSet.add(full);
                }
            }
        }
    }
}

