/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.fluid;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.fluid.fabric.SoftFluidInternalImpl;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SoftFluidInternal {
    private static final WeakHashMap<class_5455, Map<class_3611, class_6880<SoftFluid>>> FLUID_MAP = new WeakHashMap();
    private static final WeakHashMap<class_5455, Map<class_1792, class_6880<SoftFluid>>> ITEM_MAP = new WeakHashMap();

    public static class_6880<SoftFluid> fromVanillaFluid(class_3611 fluid, class_5455 registryAccess) {
        if (!FLUID_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return FLUID_MAP.get(registryAccess).get(fluid);
    }

    public static class_6880<SoftFluid> fromVanillaItem(class_1792 item, class_5455 registryAccess) {
        if (!ITEM_MAP.containsKey(registryAccess)) {
            SoftFluidInternal.populateSlaveMaps(registryAccess);
        }
        return ITEM_MAP.get(registryAccess).get(item);
    }

    private static void populateSlaveMaps(class_5455 registryAccess) {
        Map fludiMap = FLUID_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        Map itemMap = ITEM_MAP.computeIfAbsent(registryAccess, k -> new IdentityHashMap());
        fludiMap.clear();
        itemMap.clear();
        for (class_6880.class_6883 h : SoftFluidRegistry.get(registryAccess).method_40270().toList()) {
            SoftFluid s = (SoftFluid)h.comp_349();
            if (!s.isEnabled()) continue;
            for (class_6880 eq : s.getEquivalentFluids()) {
                class_3611 value = (class_3611)eq.comp_349();
                if (value == class_3612.field_15906) {
                    Moonlight.LOGGER.error("!!Invalid fluid for fluid. This is a bug! {}", (Object)h);
                    if (PlatHelper.isDev()) {
                        throw new AssertionError((Object)("Invalid fluid for fluid. This is a bug! " + String.valueOf(h)));
                    }
                }
                fludiMap.put(value, h);
            }
            s.getEquivalentFluids().forEach(f -> fludiMap.put((class_3611)f.comp_349(), h));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || !MLBuiltinSoftFluids.WATER.is((class_6880<SoftFluid>)h)) {
                    if (i == class_1802.field_8162) {
                        Moonlight.LOGGER.error("!!Invalid item for fluid. This is a bug! {}", (Object)h);
                        if (PlatHelper.isDev()) {
                            throw new AssertionError((Object)("Invalid item for fluid. This is a bug! " + String.valueOf(h)));
                        }
                    }
                    itemMap.put(i, h);
                }
            });
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidInternalImpl.init();
    }

    public static void postInitClient(class_5455 ra) {
        FLUID_MAP.clear();
        ITEM_MAP.clear();
        class_2378<SoftFluid> reg = SoftFluidRegistry.get(ra);
        for (SoftFluid f : reg) {
            f.afterInit();
        }
        SoftFluidColors.refreshParticleColors();
    }

    public static void onDataSyncToPlayer(class_3222 player, boolean isJoined) {
        if (isJoined) {
            NetworkHelper.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
        }
    }

    public static void doPostInitServer(class_5455 ra) {
        SoftFluidInternal.populateSlaveMaps(ra);
        SoftFluidInternal.registerExistingVanillaFluids(ra, FLUID_MAP.get(ra), ITEM_MAP.get(ra));
        for (SoftFluid f : SoftFluidRegistry.get(ra)) {
            f.afterInit();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(class_5455 ra, Map<class_3611, class_6880<SoftFluid>> fluidMap, Map<class_1792, class_6880<SoftFluid>> itemMap) {
        void var2_2;
        void var1_1;
        SoftFluidInternalImpl.registerExistingVanillaFluids(ra, (Map<class_3611, class_6880<SoftFluid>>)var1_1, (Map<class_1792, class_6880<SoftFluid>>)var2_2);
    }
}

