/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.util.NIOKt;
import io.ktor.websocket.UtilsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/ktor/websocket/SimpleFrameCollector;", "", "<init>", "()V", "Ljava/nio/ByteBuffer;", "bb", "", "handle", "(Ljava/nio/ByteBuffer;)V", "", "length", "start", "(ILjava/nio/ByteBuffer;)V", "maskKey", "take", "(Ljava/lang/Integer;)Ljava/nio/ByteBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "", "getHasRemaining", "()Z", "hasRemaining", "kotlin.jvm.PlatformType", "maskBuffer", "remaining", "I", "ktor-websockets"})
public final class SimpleFrameCollector {
    private int remaining;
    @Nullable
    private ByteBuffer buffer;
    private final ByteBuffer maskBuffer = ByteBuffer.allocate(4);

    public final boolean getHasRemaining() {
        return this.remaining > 0;
    }

    public final void start(int length, @NotNull ByteBuffer bb) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
                if (!(this.remaining == 0)) {
                    boolean bl = false;
                    throw new IllegalStateException("remaining should be 0");
                }
                this.remaining = length;
                if (this.buffer == null) break block4;
                ByteBuffer byteBuffer = this.buffer;
                Intrinsics.checkNotNull((Object)byteBuffer);
                if (byteBuffer.capacity() >= length) break block5;
            }
            this.buffer = ByteBuffer.allocate(length);
        }
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull((Object)byteBuffer);
        byteBuffer.clear();
        this.handle(bb);
    }

    public final void handle(@NotNull ByteBuffer bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull((Object)byteBuffer);
        this.remaining -= NIOKt.moveTo(bb, byteBuffer, this.remaining);
    }

    @NotNull
    public final ByteBuffer take(@Nullable Integer maskKey) {
        ByteBuffer byteBuffer = this.buffer;
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBuffer $this$take_u24lambda_u2d1 = byteBuffer;
        boolean bl = false;
        $this$take_u24lambda_u2d1.flip();
        ByteBuffer view = $this$take_u24lambda_u2d1.slice();
        if (maskKey != null) {
            this.maskBuffer.clear();
            this.maskBuffer.asIntBuffer().put(maskKey);
            this.maskBuffer.clear();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            ByteBuffer byteBuffer2 = this.maskBuffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"maskBuffer");
            UtilsKt.xor(view, byteBuffer2);
        }
        this.buffer = null;
        ByteBuffer byteBuffer3 = view.asReadOnlyBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"buffer!!.run {\n        f\u2026.asReadOnlyBuffer()\n    }");
        return byteBuffer3;
    }
}

