/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.craftify.ui;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.components.Window;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.state.BasicState;
import gg.essential.elementa.state.MappedState;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.craftify.ui.UITextMarquee;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R \u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010\u001c\u00a8\u0006&"}, d2={"Ltech/thatgravyboat/craftify/ui/UITextMarquee;", "Lgg/essential/elementa/UIComponent;", "", "frames", "", "text", "<init>", "(FLjava/lang/String;)V", "", "animationFrame", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)Ltech/thatgravyboat/craftify/ui/UITextMarquee;", "", "shouldUpdate", "()Z", "splitText", "(Ljava/lang/String;)Ljava/lang/String;", "updateText", "(Ljava/lang/String;)V", "", "elapsedFrames", "I", "F", "ogText", "Ljava/lang/String;", "shouldAnimate", "Z", "Lgg/essential/elementa/state/MappedState;", "textState", "Lgg/essential/elementa/state/MappedState;", "totalFrames", "Craftify"})
@SourceDebugExtension(value={"SMAP\nUITextMarquee.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UITextMarquee.kt\ntech/thatgravyboat/craftify/ui/UITextMarquee\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public class UITextMarquee
extends UIComponent {
    private final float frames;
    @NotNull
    private final MappedState<String, String> textState;
    @NotNull
    private String ogText;
    private boolean shouldAnimate;
    private int elapsedFrames;
    private int totalFrames;

    public UITextMarquee(float frames, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.frames = frames;
        this.textState = new BasicState((Object)(text + "   ")).map((Function1)textState.1.INSTANCE);
        this.ogText = text;
    }

    public /* synthetic */ UITextMarquee(float f, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        this(f, string);
    }

    private final String getText() {
        return (String)this.textState.get();
    }

    private final UITextMarquee setText(String text) {
        UITextMarquee uITextMarquee;
        UITextMarquee $this$setText_u24lambda_u240 = uITextMarquee = this;
        boolean bl = false;
        $this$setText_u24lambda_u240.textState.set((Object)text);
        return uITextMarquee;
    }

    private final boolean shouldUpdate() {
        return this.elapsedFrames >= this.totalFrames;
    }

    public void animationFrame() {
        super.animationFrame();
        if (this.shouldAnimate) {
            int n = this.elapsedFrames;
            this.elapsedFrames = n + 1;
            if (this.shouldUpdate()) {
                String newText = this.getText();
                this.setText(StringsKt.drop((String)newText, (int)1) + StringsKt.take((String)newText, (int)1));
                this.elapsedFrames = 0;
                this.totalFrames = (int)(this.frames * (float)Window.Companion.of((UIComponent)this).getAnimationFPS());
            }
        }
    }

    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        String text = (String)this.textState.get();
        if (((CharSequence)text).length() == 0) {
            return;
        }
        this.beforeDraw(matrixStack);
        float x = this.getLeft();
        float y = this.getTop();
        Color color = this.getColor();
        if (color.getAlpha() <= 10) {
            super.draw(matrixStack);
            return;
        }
        UGraphics.enableBlend();
        String formattedText = this.splitText(text);
        this.getFontProvider().drawString(matrixStack, formattedText, color, x, y, 10.0f, 1.0f, true, null);
        super.draw(matrixStack);
    }

    public final void updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!Intrinsics.areEqual((Object)text, (Object)this.ogText)) {
            this.setText(text + "   ");
            this.ogText = text;
        }
        this.shouldAnimate = UtilitiesKt.width$default((String)text, (float)0.0f, null, (int)3, null) > this.getWidth();
    }

    private final String splitText(String text) {
        float charWidth;
        int index;
        if (UtilitiesKt.width$default((String)text, (float)0.0f, null, (int)3, null) <= this.getWidth()) {
            return text;
        }
        double currWidth = 0.0;
        for (index = 0; index < text.length() && !(currWidth + (double)(charWidth = UtilitiesKt.width$default((char)text.charAt(index), (float)0.0f, (int)1, null)) > (double)this.getWidth()); ++index) {
            currWidth += (double)charWidth;
        }
        String string = text.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

