/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_437;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.gui.screen.ConfigOptionHotkeyDialog;
import org.anti_ad.mc.common.gui.screen.ConfigScreenBase;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\r\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u000f\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ=\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0011\u0010 J%\u0010#\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010&\u001a\u00020\u00062\n\u0010\n\u001a\u00020%\"\u00020\u0004\u00a2\u0006\u0004\b&\u0010'J\u0019\u0010(\u001a\u00020\u00062\n\u0010\n\u001a\u00020%\"\u00020\u0004\u00a2\u0006\u0004\b(\u0010'J\u0019\u0010)\u001a\u00020\u00062\n\u0010\n\u001a\u00020%\"\u00020\u0004\u00a2\u0006\u0004\b)\u0010'J\u0019\u0010*\u001a\u00020\u00062\n\u0010\n\u001a\u00020%\"\u00020\u0004\u00a2\u0006\u0004\b*\u0010'J\u0019\u0010+\u001a\u00020\u00062\n\u0010\n\u001a\u00020%\"\u00020\u0004\u00a2\u0006\u0004\b+\u0010'J\u0015\u0010.\u001a\u00020\u00062\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b.\u0010/J\u0015\u00100\u001a\u00020\u00062\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b0\u0010/J\u0015\u00101\u001a\u00020\u00062\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b1\u0010/J\u0015\u00102\u001a\u00020\u00062\u0006\u0010-\u001a\u00020,\u00a2\u0006\u0004\b2\u0010/R\u001d\u00104\u001a\b\u0012\u0004\u0012\u00020\u0004038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R0\u00109\u001a\b\u0012\u0004\u0012\u00020\u0004032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0004038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b9\u00105\u001a\u0004\b:\u00107R$\u0010;\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R$\u0010?\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b?\u0010<\u001a\u0004\b@\u0010>R.\u0010B\u001a\u0004\u0018\u00010A2\b\u00108\u001a\u0004\u0018\u00010A8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010IR\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020,038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u00105R\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020,038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u00105\u00a8\u0006M"}, d2={"Lorg/anti_ad/mc/common/input/GlobalInputHandler;", "", "<init>", "()V", "", "key", "", "isWaitingForRelease", "(I)Z", "", "keyCodes", "Lorg/anti_ad/mc/common/input/KeybindSettings;", "settings", "isActivated", "(Ljava/util/List;Lorg/anti_ad/mc/common/input/KeybindSettings;)Z", "isPressing", "action", "onKey", "(II)Z", "onInput", "()Z", "", "handleAssignKeybind", "aKeyCode", "", "window", "isKeyDown", "(IJ)Z", "scanCode", "modifiers", "checkPressing", "handle", "(IIIIZJ)Z", "button", "mods", "onMouseButton", "(III)Z", "", "shiftAnd", "([I)Z", "altAnd", "ctrlAnd", "superAnd", "arePressed", "Lorg/anti_ad/mc/common/IInputHandler;", "inputHandler", "register", "(Lorg/anti_ad/mc/common/IInputHandler;)Z", "unregister", "registerCancellable", "unregisterCancellable", "", "pressedKeys", "Ljava/util/Set;", "getPressedKeys", "()Ljava/util/Set;", "value", "previousPressedKeys", "getPreviousPressedKeys", "lastKey", "I", "getLastKey", "()I", "lastAction", "getLastAction", "Lorg/anti_ad/mc/common/input/IKeybind;", "currentAssigningKeybind", "Lorg/anti_ad/mc/common/input/IKeybind;", "getCurrentAssigningKeybind", "()Lorg/anti_ad/mc/common/input/IKeybind;", "setCurrentAssigningKeybind", "(Lorg/anti_ad/mc/common/input/IKeybind;)V", "pressedFirstKey", "Z", "ignoreLeftClick", "registered", "registeredCancellable", "fabric-1.21"})
@SourceDebugExtension(value={"SMAP\nGlobalInputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1755#2,3:284\n1863#2,2:287\n1863#2,2:289\n*S KotlinDebug\n*F\n+ 1 GlobalInputHandler.kt\norg/anti_ad/mc/common/input/GlobalInputHandler\n*L\n111#1:284,3\n115#1:287,2\n187#1:289,2\n*E\n"})
public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set<Integer> pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set<Integer> previousPressedKeys = new LinkedHashSet();
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set<IInputHandler> registered;
    @NotNull
    private static final Set<IInputHandler> registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set<Integer> getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set<Integer> getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int key) {
        return pressedKeys.contains(key);
    }

    public final boolean isActivated(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!settings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        Set<Integer> validateKeys = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(settings, validateKeys, keyCodes, false, 4, null);
    }

    public final boolean isPressing(@NotNull List<Integer> keyCodes, @NotNull KeybindSettings settings) {
        Intrinsics.checkNotNullParameter(keyCodes, (String)"keyCodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (keyCodes.isEmpty()) {
            return false;
        }
        if (!VanillaUtil.INSTANCE.isValidScreen(settings.getContext())) {
            return false;
        }
        return settings.validates(pressedKeys, keyCodes, false);
    }

    private final boolean onKey(int key, int action) {
        boolean isPress;
        boolean bl = isPress = action == 1;
        if (isPress && pressedKeys.contains(key)) {
            return false;
        }
        boolean bl2 = isPress ? pressedKeys.add(key) : pressedKeys.remove(key);
        lastKey = key;
        lastAction = action;
        return this.onInput();
    }

    private final boolean onInput() {
        IInputHandler it;
        boolean bl;
        block9: {
            if (currentAssigningKeybind != null) {
                if (lastAction == 1) {
                    this.handleAssignKeybind();
                } else {
                    this.handleAssignKeybind();
                }
                return true;
            }
            class_437 screen = Vanilla.INSTANCE.screen();
            if (screen != null && (screen instanceof ConfigScreenBase || screen instanceof ConfigOptionHotkeyDialog)) {
                return false;
            }
            Iterable $this$any$iv = registeredCancellable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (IInputHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.onInput(lastKey, lastAction)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$forEach$iv = registered;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IInputHandler)element$iv;
            boolean bl3 = false;
            it.onInput(lastKey, lastAction);
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind value) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = value;
    }

    private final void handleAssignKeybind() {
        List<Integer> pressedKeys;
        block14: {
            Object object;
            block13: {
                object = currentAssigningKeybind;
                if (object == null) break block13;
                IKeybind $this$handleAssignKeybind_u24lambda_u242 = object;
                boolean bl = false;
                List<Integer> list = $this$handleAssignKeybind_u24lambda_u242.getSettings().getModifierKey().handleKeys(CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys));
                object = list;
                if (list != null) break block14;
            }
            object = pressedKeys = CollectionsKt.toList((Iterable)GlobalInputHandler.pressedKeys);
        }
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(CollectionsKt.emptyList());
                }
                this.setCurrentAssigningKeybind(null);
            } else {
                IKeybind iKeybind = currentAssigningKeybind;
                if (iKeybind != null) {
                    iKeybind.setKeyCodes(pressedKeys);
                }
            }
        } else {
            if (lastKey == -100) {
                ignoreLeftClick = false;
            }
            if (pressedKeys.isEmpty() && pressedFirstKey) {
                this.setCurrentAssigningKeybind(null);
            }
        }
    }

    public final boolean isKeyDown(int aKeyCode, long window) {
        int keyCode = aKeyCode;
        if (keyCode >= 0) {
            return GLFW.glfwGetKey((long)window, (int)keyCode) == 1;
        }
        return (keyCode += 100) >= 0 && GLFW.glfwGetMouseButton((long)window, (int)keyCode) == 1;
    }

    public final boolean onKey(int key, int scanCode, int action, int modifiers, boolean checkPressing, long handle) {
        DebugInfos.INSTANCE.onKey(key, scanCode, action, modifiers);
        previousPressedKeys.clear();
        previousPressedKeys.addAll((Collection<Integer>)pressedKeys);
        if (handle != 0L && checkPressing && !((Collection)pressedKeys).isEmpty()) {
            Set pressed = CollectionsKt.toSet((Iterable)pressedKeys);
            pressedKeys.clear();
            Iterable $this$forEach$iv = pressed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (INSTANCE.isKeyDown(it, handle)) {
                    pressedKeys.add(it);
                    continue;
                }
                if (action != 1) continue;
                INSTANCE.onKey(it, 0);
            }
        }
        return switch (action) {
            case 0, 1 -> this.onKey(key, action);
            default -> false;
        };
    }

    public final boolean onMouseButton(int button, int action, int mods) {
        DebugInfos.INSTANCE.onMouseButton(button, action, mods);
        previousPressedKeys.clear();
        previousPressedKeys.addAll((Collection<Integer>)pressedKeys);
        return switch (action) {
            case 0, 1 -> {
                int normalized;
                int v0 = normalized = button >= 0 ? button - 100 : button;
                if (normalized < 0) {
                    Log.INSTANCE.trace("Mouse button " + normalized + ", " + (action == 1 ? "pressed" : "released"));
                }
                yield this.onKey(normalized, action);
            }
            default -> false;
        };
    }

    public final boolean shiftAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(340) || pressedKeys.contains(344)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean altAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(342) || pressedKeys.contains(346)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean ctrlAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(341) || pressedKeys.contains(345)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean superAnd(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return (pressedKeys.contains(343) || pressedKeys.contains(347)) && pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean arePressed(int ... keyCodes) {
        Intrinsics.checkNotNullParameter((Object)keyCodes, (String)"keyCodes");
        return pressedKeys.containsAll(ArraysKt.distinct((int[])keyCodes));
    }

    public final boolean register(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.add(inputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registered.remove(inputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.add(inputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler inputHandler) {
        Intrinsics.checkNotNullParameter((Object)inputHandler, (String)"inputHandler");
        return registeredCancellable.remove(inputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

