/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.RecipeGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class LanternRecipeGenerator
extends RecipeGenerator {
    private static final class_6862<class_1792>[] DYE_TAGS = new class_6862[]{ConventionalItemTags.WHITE_DYES, ConventionalItemTags.ORANGE_DYES, ConventionalItemTags.MAGENTA_DYES, ConventionalItemTags.LIGHT_BLUE_DYES, ConventionalItemTags.YELLOW_DYES, ConventionalItemTags.LIME_DYES, ConventionalItemTags.PINK_DYES, ConventionalItemTags.GRAY_DYES, ConventionalItemTags.LIGHT_GRAY_DYES, ConventionalItemTags.CYAN_DYES, ConventionalItemTags.PURPLE_DYES, ConventionalItemTags.BLUE_DYES, ConventionalItemTags.BROWN_DYES, ConventionalItemTags.GREEN_DYES, ConventionalItemTags.RED_DYES, ConventionalItemTags.BLACK_DYES};

    public LanternRecipeGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addMaterialRecipes(material);
        }
    }

    private void addMaterialRecipes(LanternMaterial material) {
        this.addLanternRecipe(material);
        if (material.canBeColored) {
            this.addColorRecipe(material, null);
            for (LanternColor color : LanternColor.values()) {
                this.addColorRecipe(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainRecipe(material);
        }
    }

    private void addLanternRecipe(LanternMaterial material) {
        if (material.primaryLanternIngredient == null && material.secondaryLanternIngredient == null) {
            return;
        }
        if (material.primaryLanternIngredient == null) {
            this.shaped((class_1935)material.getLanternBlock(), material.lanternRecipeCount).pattern("B B").pattern(" C ").pattern("B B").input('B', new class_1935[]{material.secondaryLanternIngredient}).input('C', new class_1935[]{() -> class_1802.field_8810}).unlockedBy(new class_1935[]{class_1802.field_8810});
        } else if (material.secondaryLanternIngredient == null) {
            this.shaped((class_1935)material.getLanternBlock(), material.lanternRecipeCount).pattern(" A ").pattern("ACA").pattern(" A ").input('A', new class_1935[]{material.primaryLanternIngredient}).input('C', new class_1935[]{() -> class_1802.field_8810}).unlockedBy(new class_1935[]{class_1802.field_8810});
        } else {
            this.shaped((class_1935)material.getLanternBlock(), material.lanternRecipeCount).pattern("BAB").pattern("ACA").pattern("BAB").input('A', new class_1935[]{material.primaryLanternIngredient}).input('B', new class_1935[]{material.secondaryLanternIngredient}).input('C', new class_1935[]{() -> class_1802.field_8810}).unlockedBy(new class_1935[]{class_1802.field_8810});
        }
    }

    private void addColorRecipe(LanternMaterial material, LanternColor color) {
        if (color == null) {
            this.shapeless(class_2960.method_60655((String)"additionallanterns", (String)(material.getSuffix() + "_lantern_colorless")), (class_1935)material.getLanternBlock()).input(LanternRecipeGenerator.getMaterialLanternTag(material)).unlockedBy(LanternRecipeGenerator.getMaterialLanternTag(material));
        } else {
            this.shapeless(class_2960.method_60655((String)"additionallanterns", (String)(material.getSuffix() + "_lantern_" + color.getSuffix())), (class_1935)material.getLanternBlock(color)).input(LanternRecipeGenerator.getMaterialLanternTag(material)).input(LanternRecipeGenerator.getColorDyeTag(color)).unlockedBy(LanternRecipeGenerator.getMaterialLanternTag(material));
        }
    }

    private static class_6862<class_1792> getMaterialLanternTag(LanternMaterial material) {
        return class_6862.method_40092((class_5321)Registries.ITEMS.getVanillaRegistry().method_30517(), (class_2960)class_2960.method_60655((String)"additionallanterns", (String)(material.getSuffix() + "_lanterns")));
    }

    private static class_6862<class_1792> getColorDyeTag(LanternColor color) {
        return DYE_TAGS[color.dyeColor.ordinal()];
    }

    private void addChainRecipe(LanternMaterial material) {
        if (material.primaryChainIngredient == null && material.secondaryChainIngredient == null) {
            return;
        }
        if (material.primaryChainIngredient == null) {
            this.shaped((class_1935)material.getChainBlock(), material.chainRecipeCount).pattern("B").pattern(" ").pattern("B").input('B', new class_1935[]{material.secondaryChainIngredient}).unlockedBy(new class_1935[]{material.secondaryChainIngredient});
        } else if (material.secondaryChainIngredient == null) {
            this.shaped((class_1935)material.getChainBlock(), material.chainRecipeCount).pattern("A").input('A', new class_1935[]{material.primaryChainIngredient}).unlockedBy(new class_1935[]{material.primaryChainIngredient});
        } else {
            this.shaped((class_1935)material.getChainBlock(), material.chainRecipeCount).pattern("B").pattern("A").pattern("B").input('A', new class_1935[]{material.primaryChainIngredient}).input('B', new class_1935[]{material.secondaryChainIngredient}).unlockedBy(new class_1935[]{material.primaryChainIngredient});
        }
    }
}

