/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.things.misc;

import com.glisco.things.Things;
import com.glisco.things.items.ThingsItems;
import com.glisco.things.items.trinkets.AgglomerationItem;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class AgglomerateRecipe
extends class_1852 {
    public AgglomerateRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        int totalItems = 0;
        for (int i = 0; i < input.method_59983(); ++i) {
            if (input.method_59984(i).method_7960()) continue;
            ++totalItems;
        }
        if (totalItems != 3) {
            return false;
        }
        if (!AgglomerateRecipe.matchOnce(input, stack -> stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION))) {
            return false;
        }
        class_1799 firstStack = AgglomerateRecipe.matchOne(input, AgglomerateRecipe::isValidItem);
        if (firstStack == null) {
            return false;
        }
        Collection firstValidSlots = AccessoriesAPI.getStackSlotTypes((class_1937)world, (class_1799)firstStack);
        return AgglomerateRecipe.matchOnce(input, stack -> {
            boolean anyCompatibleSlot = false;
            for (SlotType slotType : AccessoriesAPI.getStackSlotTypes((class_1937)world, (class_1799)stack)) {
                if (!firstValidSlots.contains(slotType)) continue;
                anyCompatibleSlot = true;
                break;
            }
            return anyCompatibleSlot && !class_1799.method_7984((class_1799)stack, (class_1799)firstStack) && AgglomerateRecipe.isValidItem(stack);
        });
    }

    private static boolean isValidItem(class_1799 stack) {
        return !stack.method_7960() && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION) && !(AccessoriesAPI.getAccessory((class_1792)stack.method_7909()) instanceof AccessoryNest) && !stack.method_31573(Things.AGGLOMERATION_BLACKLIST);
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 registries) {
        class_1799 firstTrinket = AgglomerateRecipe.matchOne(input, stack -> !stack.method_7960() && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION));
        class_1799 secondTrinket = AgglomerateRecipe.matchOne(input, stack -> !stack.method_7960() && stack != firstTrinket && !stack.method_31574(ThingsItems.EMPTY_AGGLOMERATION));
        return AgglomerationItem.createStack(firstTrinket, secondTrinket);
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1865<?> method_8119() {
        return Serializer.INSTANCE;
    }

    private static boolean matchOnce(class_9694 input, Predicate<class_1799> condition) {
        boolean found = false;
        for (int i = 0; i < input.method_59983(); ++i) {
            if (!condition.test(input.method_59984(i))) continue;
            if (found) {
                return false;
            }
            found = true;
        }
        return found;
    }

    private static class_1799 matchOne(class_9694 input, Predicate<class_1799> condition) {
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 stack = input.method_59984(i);
            if (!condition.test(stack)) continue;
            return stack;
        }
        return null;
    }

    public static class Serializer
    extends class_1866<AgglomerateRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(AgglomerateRecipe::new);
        }
    }
}

