/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfchest.gametest.testcase;

import atonkish.reinfchest.ReinforcedChestsMod;
import atonkish.reinfchest.gametest.util.MockServerPlayerHelper;
import atonkish.reinfchest.item.ModItems;
import atonkish.reinfcore.util.ReinforcingMaterials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_8779;

public class AdvancementTests {
    private static final String BATCH_ID = String.format("%s:AdvancementBatch", "reinfchest");
    public static final Collection<class_4529> TEST_FUNCTIONS = new ArrayList<class_4529>(){
        {
            this.add(AdvancementTests.createTest("Obtain Copper Chest recipe advancement by having Chest", class_1802.field_8106, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/copper_chest")));
            this.add(AdvancementTests.createTest("Obtain Copper Chest recipe advancement by having Copper Ingot", class_1802.field_27022, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/copper_chest")));
            this.add(AdvancementTests.createTest("Obtain Iron Chest recipe advancement by having Copper Chest", ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("copper")), class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/iron_chest")));
            this.add(AdvancementTests.createTest("Obtain Iron Chest recipe advancement by having Iron Ingot", class_1802.field_8620, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/iron_chest")));
            this.add(AdvancementTests.createTest("Obtain Gold Chest recipe advancement by having Iron Chest", ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("iron")), class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/gold_chest")));
            this.add(AdvancementTests.createTest("Obtain Gold Chest recipe advancement by having Gold Ingot", class_1802.field_8695, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/gold_chest")));
            this.add(AdvancementTests.createTest("Obtain Diamond Chest recipe advancement by having Gold Chest", ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("gold")), class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/diamond_chest")));
            this.add(AdvancementTests.createTest("Obtain Diamond Chest recipe advancement by having Diamond", class_1802.field_8477, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/diamond_chest")));
            this.add(AdvancementTests.createTest("Obtain Netherite Chest recipe advancement by having Diamond Chest", ModItems.REINFORCED_CHEST_MAP.get(ReinforcingMaterials.MAP.get("diamond")), class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/netherite_chest_smithing")));
            this.add(AdvancementTests.createTest("Obtain Netherite Chest recipe advancement by having Netherite Ingot", class_1802.field_22020, class_2960.method_60655((String)"reinfchest", (String)"recipes/decorations/netherite_chest_smithing")));
        }
    };

    private static class_4529 createTest(String name, class_1792 item, class_2960 advancementId) {
        String testName = String.format("%s %s %s", "reinfchest", AdvancementTests.class.getSimpleName(), name).replace(" ", "_");
        return new class_4529(BATCH_ID, testName, "fabric-gametest-api-v1:empty", class_4525.method_29408((int)0), 100, 0L, true, false, 1, 1, false, context -> {
            class_3222 player = MockServerPlayerHelper.spawn(context, class_1934.field_9215, class_243.method_24954((class_2382)class_2338.field_10980));
            class_8779 entry = context.method_35943().method_8503().method_3851().method_12896(advancementId);
            class_167 progress = player.method_14236().method_12882(entry);
            CompletableFuture futurePartialAct1 = new CompletableFuture();
            CompletableFuture futurePartialAct2 = new CompletableFuture();
            HashMap progressMap = new HashMap();
            String progressMapKeyBeforeHavingItem = "beforeHavingItem";
            String progressMapKeyAfterHavingItem = "afterHavingItem";
            long tickOrigin = 0L;
            context.method_35951(tickOrigin, () -> {
                progressMap.put(progressMapKeyBeforeHavingItem, progress.method_740());
                player.method_7270(new class_1799((class_1935)item));
                futurePartialAct1.complete(null);
            });
            long tickObtained = 1L;
            context.method_35951(tickObtained, () -> {
                progressMap.put(progressMapKeyAfterHavingItem, progress.method_740());
                futurePartialAct2.complete(null);
            });
            CompletableFuture.allOf(futurePartialAct1, futurePartialAct2).thenRun(() -> {
                try {
                    context.method_49994(((Boolean)progressMap.get(progressMapKeyBeforeHavingItem)).booleanValue(), String.format("Expected that advancement %s has not been done yet, but it has been already done.", entry));
                    context.method_46226(((Boolean)progressMap.get(progressMapKeyAfterHavingItem)).booleanValue(), String.format("Expected that advancement %s has been done, but it has not been done yet.", entry));
                }
                catch (Exception e) {
                    ReinforcedChestsMod.LOGGER.error("[{}] {}", (Object)testName, (Object)e.getMessage());
                    throw e;
                }
                finally {
                    MockServerPlayerHelper.destroy(context, player);
                }
                context.method_36036();
            });
        });
    }
}

