/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam;

import net.minecraft.class_1061;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.minecraft.class_642;
import net.minecraft.class_743;
import net.minecraft.class_744;
import net.xolt.freecam.config.ModBindings;
import net.xolt.freecam.config.ModConfig;
import net.xolt.freecam.tripod.TripodRegistry;
import net.xolt.freecam.tripod.TripodSlot;
import net.xolt.freecam.util.FreeCamera;
import net.xolt.freecam.util.FreecamPosition;
import net.xolt.freecam.variant.api.BuildVariant;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Freecam {
    public static final class_310 MC = class_310.method_1551();
    public static final String MOD_ID = "freecam";
    private static boolean freecamEnabled = false;
    private static boolean tripodEnabled = false;
    private static boolean playerControlEnabled = false;
    private static boolean disableNextTick = false;
    private static final TripodRegistry tripods = new TripodRegistry();
    private static TripodSlot activeTripod = TripodSlot.NONE;
    private static FreeCamera freeCamera;
    private static class_5498 rememberedF5;

    @ApiStatus.Internal
    public static void preTick(class_310 mc) {
        if ((disableNextTick || Freecam.isRestrictedOnServer()) && Freecam.isEnabled()) {
            Freecam.toggle();
        }
        disableNextTick = false;
        if (Freecam.isEnabled()) {
            if (mc.field_1724 != null && mc.field_1724.field_3913 instanceof class_743 && !Freecam.isPlayerControlEnabled()) {
                class_744 input = new class_744();
                input.field_3903 = mc.field_1724.field_3913.field_3903;
                mc.field_1724.field_3913 = input;
            }
            mc.field_1773.method_35768(ModConfig.INSTANCE.visual.showHand);
        }
    }

    @ApiStatus.Internal
    public static void postTick(class_310 mc) {
        ModBindings.forEach(class_1061::method_4622);
    }

    @ApiStatus.Internal
    public static void onDisconnect() {
        if (Freecam.isEnabled()) {
            Freecam.toggle();
        }
        tripods.clear();
    }

    @ApiStatus.Internal
    public static boolean activateTripodHandler() {
        boolean activated = false;
        for (class_304 combo : Freecam.MC.field_1690.field_1852) {
            while (combo.method_1436()) {
                Freecam.toggleTripod(TripodSlot.ofKeyCode(combo.method_1429().method_1444()));
                activated = true;
            }
        }
        return activated;
    }

    @ApiStatus.Internal
    public static boolean resetTripodHandler() {
        boolean reset = false;
        for (class_304 key : Freecam.MC.field_1690.field_1852) {
            while (key.method_1436()) {
                Freecam.resetCamera(TripodSlot.ofKeyCode(key.method_1429().method_1444()));
                reset = true;
            }
        }
        return reset;
    }

    @ApiStatus.AvailableSince(value="0.3.1")
    public static void toggle() {
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyFreecam) {
                Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.method_1558().field_3761}), true);
            }
            return;
        }
        if (tripodEnabled) {
            Freecam.toggleTripod(activeTripod);
            return;
        }
        if (freecamEnabled) {
            Freecam.onDisableFreecam();
        } else {
            Freecam.onEnableFreecam();
        }
        boolean bl = freecamEnabled = !freecamEnabled;
        if (!freecamEnabled) {
            Freecam.onDisabled();
        }
    }

    private static void toggleTripod(TripodSlot tripod) {
        if (tripod == TripodSlot.NONE) {
            return;
        }
        if (Freecam.isRestrictedOnServer()) {
            if (ModConfig.INSTANCE.notification.notifyTripod) {
                Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.restrictedByConfig", (Object[])new Object[]{Freecam.MC.method_1558().field_3761}), true);
            }
            return;
        }
        if (tripodEnabled) {
            if (activeTripod == tripod) {
                Freecam.onDisableTripod();
                tripodEnabled = false;
            } else {
                Freecam.onDisableTripod();
                Freecam.onEnableTripod(tripod);
            }
        } else {
            if (freecamEnabled) {
                Freecam.toggle();
            }
            Freecam.onEnableTripod(tripod);
            tripodEnabled = true;
        }
        if (!tripodEnabled) {
            Freecam.onDisabled();
        }
    }

    @ApiStatus.AvailableSince(value="1.1.8")
    public static void switchControls() {
        if (!Freecam.isEnabled()) {
            return;
        }
        if (playerControlEnabled) {
            Freecam.freeCamera.field_3913 = new class_743(Freecam.MC.field_1690);
        } else {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
            Freecam.freeCamera.field_3913 = new class_744();
        }
        playerControlEnabled = !playerControlEnabled;
    }

    private static void onEnableTripod(TripodSlot tripod) {
        Freecam.onEnable();
        FreecamPosition position = tripods.get(tripod);
        boolean chunkLoaded = false;
        if (position != null) {
            class_1923 chunkPos = position.getChunkPos();
            chunkLoaded = Freecam.MC.field_1687.method_2935().method_12123(chunkPos.field_9181, chunkPos.field_9180);
        }
        if (!chunkLoaded) {
            Freecam.resetCamera(tripod);
            position = null;
        }
        freeCamera = new FreeCamera(-420 - tripod.ordinal());
        if (position == null) {
            Freecam.moveToPlayer();
        } else {
            Freecam.moveToPosition(position);
        }
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        activeTripod = tripod;
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.openTripod", (Object[])new Object[]{tripod}), true);
        }
    }

    private static void onDisableTripod() {
        tripods.put(activeTripod, new FreecamPosition((class_1297)freeCamera));
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.closeTripod", (Object[])new Object[]{activeTripod}), true);
        }
        activeTripod = TripodSlot.NONE;
    }

    private static void onEnableFreecam() {
        Freecam.onEnable();
        freeCamera = new FreeCamera(-420);
        Freecam.moveToPlayer();
        freeCamera.spawn();
        MC.method_1504((class_1297)freeCamera);
        if (ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.enable"), true);
        }
    }

    private static void onDisableFreecam() {
        Freecam.onDisable();
        if (Freecam.MC.field_1724 != null && ModConfig.INSTANCE.notification.notifyFreecam) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43471((String)"msg.freecam.disable"), true);
        }
    }

    private static void onEnable() {
        Freecam.MC.field_1730 = false;
        Freecam.MC.field_1773.method_35768(ModConfig.INSTANCE.visual.showHand);
        rememberedF5 = Freecam.MC.field_1690.method_31044();
        if (Freecam.MC.field_1773.method_19418().method_19333()) {
            Freecam.MC.field_1690.method_31043(class_5498.field_26664);
        }
    }

    private static void onDisable() {
        Freecam.MC.field_1730 = true;
        Freecam.MC.field_1773.method_35768(true);
        MC.method_1504((class_1297)Freecam.MC.field_1724);
        playerControlEnabled = false;
        freeCamera.despawn();
        Freecam.freeCamera.field_3913 = new class_744();
        freeCamera = null;
        if (Freecam.MC.field_1724 != null) {
            Freecam.MC.field_1724.field_3913 = new class_743(Freecam.MC.field_1690);
        }
    }

    private static void onDisabled() {
        if (rememberedF5 != null) {
            Freecam.MC.field_1690.method_31043(rememberedF5);
        }
    }

    private static void resetCamera(TripodSlot tripod) {
        if (tripodEnabled && activeTripod != TripodSlot.NONE && activeTripod == tripod && freeCamera != null) {
            Freecam.moveToPlayer();
        } else {
            tripods.put(tripod, null);
        }
        if (ModConfig.INSTANCE.notification.notifyTripod) {
            Freecam.MC.field_1724.method_7353((class_2561)class_2561.method_43469((String)"msg.freecam.tripodReset", (Object[])new Object[]{tripod}), true);
        }
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToEntity(@Nullable class_1297 entity) {
        if (freeCamera == null) {
            return;
        }
        if (entity == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.method_5719(entity);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPosition(@Nullable FreecamPosition position) {
        if (freeCamera == null) {
            return;
        }
        if (position == null) {
            Freecam.moveToPlayer();
            return;
        }
        freeCamera.applyPosition(position);
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.3")
    public static void moveToPlayer() {
        if (freeCamera == null) {
            return;
        }
        freeCamera.method_5719((class_1297)Freecam.MC.field_1724);
        freeCamera.applyPerspective(ModConfig.INSTANCE.visual.perspective, ModConfig.INSTANCE.collision.alwaysCheck || !ModConfig.INSTANCE.collision.ignoreAll || !BuildVariant.getInstance().cheatsPermitted());
    }

    @ApiStatus.AvailableSince(value="0.4.0")
    public static FreeCamera getFreeCamera() {
        return freeCamera;
    }

    @ApiStatus.AvailableSince(value="1.2.3")
    public static void disableNextTick() {
        disableNextTick = true;
    }

    @ApiStatus.AvailableSince(value="0.2.2")
    public static boolean isEnabled() {
        return freecamEnabled || tripodEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.0.0")
    public static boolean isPlayerControlEnabled() {
        return playerControlEnabled;
    }

    @ApiStatus.Experimental
    @ApiStatus.AvailableSince(value="1.2.4")
    public static boolean isRestrictedOnServer() {
        class_642 server = MC.method_1558();
        ModConfig.ServerRestriction mode = ModConfig.INSTANCE.servers.mode;
        if (mode == ModConfig.ServerRestriction.NONE || server == null || MC.method_1496()) {
            return false;
        }
        String ip = server.field_3761.trim().toLowerCase();
        return switch (mode) {
            case ModConfig.ServerRestriction.WHITELIST -> ModConfig.INSTANCE.servers.whitelist.stream().map(String::trim).map(String::toLowerCase).noneMatch(ip::equals);
            case ModConfig.ServerRestriction.BLACKLIST -> ModConfig.INSTANCE.servers.blacklist.stream().map(String::trim).map(String::toLowerCase).anyMatch(ip::equals);
            default -> throw new IllegalStateException("Unexpected mode value in Freecam.isRestrictedOnServer: " + String.valueOf((Object)mode));
        };
    }

    static {
        rememberedF5 = null;
    }
}

