/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.enchantmentdisabler.mixson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.List;
import me.pajic.enchantmentdisabler.Main;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.ramixin.mixson.DebugMode;
import net.ramixin.mixson.Mixson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceModifications {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EnchantmentDisabler-ResourceModifications");
    private static final List<String> DISABLER_TARGETS = List.of("in_enchanting_table", "non_treasure", "on_mob_spawn_equipment", "on_random_loot", "on_traded_equipment", "tradeable", "treasure");

    public static void init() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Mixson.setDebugMode((DebugMode)DebugMode.EXPORT);
        }
        if (Main.CONFIG.disablerEnabled()) {
            DISABLER_TARGETS.forEach(name -> Mixson.registerModificationEvent((class_2960)class_2960.method_60656((String)("tags/enchantment/" + name)), (class_2960)class_2960.method_60655((String)"enchantmentdisabler", (String)("modify_" + name)), jsonElement -> {
                List values = jsonElement.getAsJsonObject().getAsJsonArray("values").asList();
                values.removeIf(value -> Main.CONFIG.disabledEnchantments().contains(value.getAsString()));
                JsonArray newValues = new JsonArray();
                values.forEach(arg_0 -> ((JsonArray)newValues).add(arg_0));
                jsonElement.getAsJsonObject().add("values", (JsonElement)newValues);
                return jsonElement;
            }));
        }
        if (Main.CONFIG.maxLevel.modifyMaxLevels()) {
            Main.CONFIG.maxLevel.maxLevels().forEach(entry -> {
                String[] split1 = entry.split("/", 2);
                if (split1.length != 2) {
                    LOGGER.error("Invalid max level entry: {}", entry);
                } else {
                    String entryString = split1[0];
                    try {
                        int maxLevel = Integer.parseInt(split1[1]);
                        String[] split2 = entryString.split(":", 2);
                        if (split2.length != 2) {
                            LOGGER.error("Enchantment in max level entry must be in format namespace:enchantment: {}", entry);
                        } else {
                            String namespace = split2[0];
                            String enchantment = split2[1];
                            Mixson.registerModificationEvent((class_2960)class_2960.method_60655((String)namespace, (String)("enchantment/" + enchantment)), (class_2960)class_2960.method_60655((String)"enchantmentdisabler", (String)("modify_" + enchantment + "_max_level")), jsonElement -> {
                                jsonElement.getAsJsonObject().addProperty("max_level", (Number)maxLevel);
                                return jsonElement;
                            });
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Max level is not a number in max level entry: {}", entry);
                    }
                }
            });
        }
    }
}

