/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.config.LightSourceSettingEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public final class DynamicLightHandlers {
    private DynamicLightHandlers() {
        throw new UnsupportedOperationException("DynamicLightHandlers only contains static definitions.");
    }

    public static void registerDefaultHandlers() {
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_38384, allay -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6099, DynamicLightHandler.makeHandler(blaze -> 10, blaze -> true));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6046, DynamicLightHandler.makeCreeperEntityHandler(null));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6091, entity -> {
            int luminance = 0;
            if (entity.method_7027() != null) {
                luminance = entity.method_7027().method_26213();
            }
            return luminance;
        });
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6052, entity -> LambDynLights.getLuminanceFromItemStack(entity.method_6983(), entity.method_5869()));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6043, entity -> {
            class_1937 world = entity.method_37908();
            return LambDynLights.getLuminanceFromItemStack(entity.method_6940(), !world.method_8316(entity.method_24515()).method_15769());
        });
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_28401, entity -> {
            class_1937 world = entity.method_37908();
            return Math.max(14, LambDynLights.getLuminanceFromItemStack(entity.method_6940(), !world.method_8316(entity.method_24515()).method_15769()));
        });
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6102, entity -> (double)entity.field_7388 > 0.6 ? 11 : 8);
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6135, entity -> 8);
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_28402, entity -> (int)class_3532.method_37166((float)0.0f, (float)12.0f, (float)(1.0f - (float)entity.method_33334() / 10.0f)));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6066, DynamicLightHandler.makeHandler(ball -> 14, ball -> true));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6049, DynamicLightHandler.makeHandler(ball -> 12, ball -> true));
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6129, ball -> 14);
        DynamicLightHandlers.registerDynamicLightHandler(class_1299.field_6130, ball -> 12);
    }

    public static <T extends class_1297> void registerDynamicLightHandler(class_1299<T> type, DynamicLightHandler<T> handler) {
        DynamicLightHandlers.register((DynamicLightHandlerHolder)type, handler);
    }

    private static <T> void register(DynamicLightHandlerHolder<T> holder, DynamicLightHandler<T> handler) {
        DynamicLightHandler registeredHandler = holder.lambdynlights$getDynamicLightHandler();
        if (registeredHandler != null) {
            DynamicLightHandler<Object> newHandler = entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity));
            holder.lambdynlights$setDynamicLightHandler(newHandler);
        } else {
            holder.lambdynlights$setDynamicLightHandler(handler);
        }
    }

    @Nullable
    public static <T extends class_1297> DynamicLightHandler<T> getDynamicLightHandler(class_1299<T> type) {
        return DynamicLightHandlerHolder.cast(type).lambdynlights$getDynamicLightHandler();
    }

    public static <T extends class_1297> boolean canLightUp(T entity) {
        if (entity == class_310.method_1551().field_1724 ? (Boolean)LambDynLights.get().config.getSelfLightSource().get() == false : (Boolean)LambDynLights.get().config.getEntitiesLightSource().get() == false) {
            return false;
        }
        LightSourceSettingEntry setting = DynamicLightHandlerHolder.cast(entity.method_5864()).lambdynlights$getSetting();
        return setting != null && (Boolean)setting.get() != false;
    }

    public static <T extends class_1297> int getLuminanceFrom(T entity) {
        if (!((Boolean)LambDynLights.get().config.getEntitiesLightSource().get()).booleanValue()) {
            return 0;
        }
        if (entity == class_310.method_1551().field_1724 && !((Boolean)LambDynLights.get().config.getSelfLightSource().get()).booleanValue()) {
            return 0;
        }
        DynamicLightHandler<T> handler = DynamicLightHandlers.getDynamicLightHandler(entity.method_5864());
        if (handler == null) {
            return 0;
        }
        if (!DynamicLightHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.method_37908().method_8316(class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23320(), (double)entity.method_23321())).method_15769()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }
}

