/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.block.entity;

import net.minecraft.class_2586;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.BlockEntityUtil;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.nbt.NbtCompound;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.World;

public class BlockEntityWrapper {
    private final class_2586 blockEntity;
    public static final BlockEntityWrapper EMPTY = new BlockEntityWrapper(null);

    protected BlockEntityWrapper(class_2586 blockEntity) {
        this.blockEntity = blockEntity;
    }

    public static BlockEntityWrapper of(class_2586 blockEntity) {
        return new BlockEntityWrapper(blockEntity);
    }

    public static BlockEntityWrapper of() {
        return EMPTY;
    }

    public class_2586 get() {
        return this.blockEntity;
    }

    public BlockPos getPos() {
        return BlockPos.of(this.get().method_11016());
    }

    public boolean isExist() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this == EMPTY || this.get() == null;
    }

    public boolean isRemoved() {
        return this.get().method_11015();
    }

    public void markDirty() {
        BlockEntityUtil.markDirty(this.get());
    }

    public World getWorld() {
        return World.of(BlockEntityUtil.getWorld(this.get()));
    }

    public BlockWrapper getBlock() {
        return BlockWrapper.of(BlockEntityUtil.getBlock(this.get()));
    }

    public BlockState getBlockState() {
        return BlockState.of(BlockEntityUtil.getBlockState(this.get()));
    }

    public BlockState getCachedState() {
        return BlockState.of(BlockEntityUtil.getCachedState(this.get()));
    }

    public NbtCompound createNbt() {
        return NbtCompound.of(BlockEntityUtil.getBlockEntityNbt(this.get()));
    }

    public void markRemoved() {
        BlockEntityUtil.markRemoved(this.get());
    }

    public void writeNbt(NbtCompound nbt, CompatRegistryLookup registryLookup) {
        BlockEntityUtil.writeNbt(this.get(), nbt.toMinecraft(), registryLookup);
    }

    public void readNbt(NbtCompound nbt, CompatRegistryLookup registryLookup) {
        BlockEntityUtil.readNbt(this.get(), nbt.toMinecraft(), registryLookup);
    }

    public void writeNbt(NbtCompound nbt) {
        this.writeNbt(nbt, RegistryLookupUtil.getRegistryLookup(this.get()));
    }

    public void readNbt(NbtCompound nbt) {
        this.readNbt(nbt, RegistryLookupUtil.getRegistryLookup(this.get()));
    }
}

