/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.collections;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.util.MathUtil;

public class BitArray {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private final long[] words;
    private final int capacity;

    public BitArray(int capacity) {
        this.words = new long[MathUtil.align(capacity, 64) >> 6];
        this.capacity = capacity;
    }

    public boolean get(int index) {
        return (this.words[BitArray.wordIndex(index)] & 1L << BitArray.bitIndex(index)) != 0L;
    }

    public void set(int index) {
        int n = BitArray.wordIndex(index);
        this.words[n] = this.words[n] | 1L << BitArray.bitIndex(index);
    }

    public void unset(int index) {
        int n = BitArray.wordIndex(index);
        this.words[n] = this.words[n] & (1L << BitArray.bitIndex(index) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void put(int index, boolean value) {
        int wordIndex = BitArray.wordIndex(index);
        int bitIndex = BitArray.bitIndex(index);
        long intValue = value ? 1L : 0L;
        this.words[wordIndex] = this.words[wordIndex] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | intValue << bitIndex;
    }

    public void set(int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx;
        long lastWordMask = -1L >>> -endIdx;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = -1L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] | lastWordMask;
        }
    }

    public void unset(int startIdx, int endIdx) {
        int startWordIndex = BitArray.wordIndex(startIdx);
        int endWordIndex = BitArray.wordIndex(endIdx - 1);
        long firstWordMask = -1L << startIdx ^ 0xFFFFFFFFFFFFFFFFL;
        long lastWordMask = -1L >>> -endIdx ^ 0xFFFFFFFFFFFFFFFFL;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.words[n] = this.words[n] & (firstWordMask & lastWordMask);
        } else {
            int n = startWordIndex;
            this.words[n] = this.words[n] & firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.words[i] = 0L;
            }
            int n2 = endWordIndex;
            this.words[n2] = this.words[n2] & lastWordMask;
        }
    }

    public void fill(boolean value) {
        Arrays.fill(this.words, value ? -1L : 0L);
    }

    public void unsetAll() {
        this.fill(false);
    }

    public void setAll() {
        this.fill(true);
    }

    public int countSetBits() {
        int sum = 0;
        for (long word : this.words) {
            sum += Long.bitCount(word);
        }
        return sum;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean getAndSet(int index) {
        int wordIndex = BitArray.wordIndex(index);
        long bit = 1L << BitArray.bitIndex(index);
        long word = this.words[wordIndex];
        this.words[wordIndex] = word | bit;
        return (word & bit) != 0L;
    }

    public boolean getAndUnset(int index) {
        int wordIndex = BitArray.wordIndex(index);
        long bit = 1L << BitArray.bitIndex(index);
        long word = this.words[wordIndex];
        this.words[wordIndex] = word & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        return (word & bit) != 0L;
    }

    public int nextSetBit(int fromIndex) {
        int u = BitArray.wordIndex(fromIndex);
        if (u >= this.words.length) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.words.length) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    private static int wordIndex(int index) {
        return index >> 6;
    }

    private static int bitIndex(int index) {
        return index & 0x3F;
    }
}

