/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.BoolData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.data.visitor.DataVisitor;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.MapData")
@ZenRegister
@Document(value="vanilla/api/data/MapData")
public class MapData
implements IData {
    private final class_2487 internal;
    private final Set<String> boolDataKeys;

    public MapData(class_2487 internal, Set<String> boolDataKeys) {
        this.internal = internal;
        this.boolDataKeys = boolDataKeys;
    }

    public MapData(class_2487 internal) {
        this.internal = internal;
        this.boolDataKeys = new HashSet<String>();
    }

    @ZenCodeType.Constructor
    public MapData() {
        this(new class_2487());
    }

    @ZenCodeType.Constructor
    public MapData(Map<String, IData> map) {
        this();
        this.putAll(map);
    }

    @ZenCodeType.Method
    public void putAll(Map<String, IData> map) {
        map.forEach((? super K s, ? super V iData) -> {
            if (iData != null) {
                this.getInternal().method_10566(s, iData.getInternal());
                if (iData instanceof BoolData) {
                    this.boolDataKeys.add((String)s);
                }
            }
        });
    }

    @Override
    public void remove(int index) {
        this.put(String.valueOf(index), null);
    }

    @Override
    public void remove(String key) {
        this.put(key, null);
    }

    @Override
    public IData getAt(int index) {
        return this.getAt(Integer.toString(index));
    }

    @Override
    public IData getAt(String key) {
        if (this.boolDataKeys.contains(key)) {
            return this.getInternal().method_10571(key) == 1 ? BoolData.TRUE : BoolData.FALSE;
        }
        return TagToDataConverter.convert(this.getInternal().method_10580(key));
    }

    @Override
    public boolean contains(IData other) {
        class_2487 internal = this.getInternal();
        if (other instanceof StringData) {
            return internal.method_10545(other.getAsString());
        }
        if (!other.isMappable()) {
            return false;
        }
        Map<String, IData> dataMap = other.asMap();
        for (Map.Entry<String, IData> dataEntry : dataMap.entrySet()) {
            if (!internal.method_10545(dataEntry.getKey())) {
                return false;
            }
            if (TagToDataConverter.convert(internal.method_10580(dataEntry.getKey())).contains(dataEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void put(String name, @ZenCodeType.Nullable IData data) {
        if (data == null) {
            this.boolDataKeys.remove(name);
            this.getInternal().method_10551(name);
        } else {
            if (data instanceof BoolData) {
                this.boolDataKeys.add(name);
            }
            this.getInternal().method_10566(name, data.getInternal());
        }
    }

    @Override
    public boolean equalTo(IData other) {
        if (this == other) {
            return true;
        }
        Map<String, IData> thisMap = this.asMap();
        Map<String, IData> otherMap = other.asMap();
        if (thisMap.size() != otherMap.size()) {
            return false;
        }
        for (Map.Entry<String, IData> entry : this.asMap().entrySet()) {
            if (!otherMap.containsKey(entry.getKey())) {
                return false;
            }
            if (otherMap.get(entry.getKey()).equalTo(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMappable() {
        return true;
    }

    @Override
    public Map<String, IData> asMap() {
        return this.getInternal().method_10541().stream().map((? super T s) -> Pair.of((Object)s, (Object)this.getAt((String)s))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Override
    public int length() {
        return this.getInternal().method_10546();
    }

    @Override
    public Set<String> getKeys() {
        return this.getInternal().method_10541();
    }

    @Override
    @NotNull
    public Iterator<IData> iterator() {
        return this.getInternal().method_10541().stream().map(StringData::new).iterator();
    }

    public class_2487 getInternal() {
        return this.internal;
    }

    @Override
    public IData copy() {
        return new MapData(this.getInternal(), this.boolDataKeys);
    }

    @Override
    public IData copyInternal() {
        return new MapData(this.getInternal().method_10553(), new HashSet<String>(this.boolDataKeys));
    }

    @Override
    public <T> T accept(DataVisitor<T> visitor) {
        return visitor.visitMap(this);
    }

    @Override
    public IData.Type getType() {
        return IData.Type.MAP;
    }

    public Set<String> boolDataKeys() {
        return this.boolDataKeys;
    }

    @Override
    public IData merge(IData other) {
        if (other instanceof MapData) {
            MapData map = (MapData)other;
            HashSet<String> newBoolDataKeys = new HashSet<String>(this.boolDataKeys);
            newBoolDataKeys.addAll(map.boolDataKeys);
            return new MapData(this.getInternal().method_10543(map.getInternal()), newBoolDataKeys);
        }
        throw new IllegalArgumentException("Cannot merge incompatible data type: " + String.valueOf((Object)other.getType()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapData iData = (MapData)o;
        return Objects.equals(this.getInternal(), iData.getInternal()) && Objects.equals(this.boolDataKeys, iData.boolDataKeys);
    }

    public int hashCode() {
        return Objects.hash(this.getInternal(), this.boolDataKeys);
    }

    public String toString() {
        return this.getAsString();
    }
}

