/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.impl.recipe.handler.helper.SmithingRecipeConflictChecker;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessSmithingTransformRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8786;

@IRecipeHandler.For(value=class_8060.class)
public final class SmithingTransformRecipeHandler
implements IRecipeHandler<class_8060> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super class_8060> manager, class_5455 registryAccess, class_8786<class_8060> holder) {
        class_8060 recipe = (class_8060)holder.comp_1933();
        return String.format("smithing.addTransformRecipe(%s, %s, %s, %s, %s);", StringUtil.quoteAndEscape(holder.comp_1932()), ItemStackUtil.getCommandString(recipe.method_8110((class_7225.class_7874)registryAccess)), IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getTemplate()).getCommandString(), IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getBase()).getCommandString(), IIngredient.fromIngredient(((AccessSmithingTransformRecipe)recipe).crafttweaker$getAddition()).getCommandString());
    }

    @Override
    public <U extends class_1860<?>> boolean doesConflict(IRecipeManager<? super class_8060> manager, class_8060 firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof class_8059)) {
            return false;
        }
        return SmithingRecipeConflictChecker.doesConflict(manager, (class_8059)firstRecipe, (class_8059)GenericUtil.uncheck(secondRecipe));
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super class_8060> manager, class_5455 registryAccess, class_8060 recipe) {
        AccessSmithingTransformRecipe access = (AccessSmithingTransformRecipe)recipe;
        IIngredient template = IIngredient.fromIngredient(access.crafttweaker$getTemplate());
        IIngredient base = IIngredient.fromIngredient(access.crafttweaker$getBase());
        IIngredient addition = IIngredient.fromIngredient(access.crafttweaker$getAddition());
        IDecomposedRecipe decomposed = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, List.of(template, base, addition)).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.method_8110((class_7225.class_7874)registryAccess))).build();
        return Optional.of(decomposed);
    }

    @Override
    public Optional<class_8060> recompose(IRecipeManager<? super class_8060> manager, class_5455 registryAccess, IDecomposedRecipe recipe) {
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (ingredients.size() != 3) {
            throw new IllegalArgumentException("Invalid inputs: expected three ingredients for recipe, but got " + ingredients.size() + ": " + String.valueOf(ingredients));
        }
        if (ingredients.stream().anyMatch(IIngredient::isEmpty)) {
            throw new IllegalArgumentException("Invalid inputs: empty ingredients");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid outputs: empty item");
        }
        class_1856 template = ingredients.get(0).asVanillaIngredient();
        class_1856 base = ingredients.get(1).asVanillaIngredient();
        class_1856 addition = ingredients.get(2).asVanillaIngredient();
        return Optional.of(new class_8060(template, base, addition, output.getInternal()));
    }
}

