/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.easyapi.config;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import net.pitan76.easyapi.FileControl;
import net.pitan76.easyapi.config.Config;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlConfig
extends Config {
    private DumperOptions.FlowStyle style = DumperOptions.FlowStyle.BLOCK;

    public YamlConfig(File file) {
        super(file);
    }

    public YamlConfig(String file) {
        super(file);
    }

    public YamlConfig() {
    }

    public YamlConfig(Config config) {
        super(config);
    }

    public void setStyle(DumperOptions.FlowStyle flowStyle) {
        this.style = flowStyle;
    }

    @Override
    public boolean load(File file) {
        if (!file.exists()) {
            this.configMap = new LinkedHashMap();
            return false;
        }
        try {
            String configData = FileControl.fileReadContents(file);
            Yaml yaml = new Yaml();
            this.configMap = (Map)yaml.load(configData);
            return true;
        }
        catch (Exception e) {
            this.configMap = new LinkedHashMap();
            return false;
        }
    }

    @Override
    public boolean save(File file, boolean pretty) {
        try {
            String configData = this.toYaml(pretty);
            FileControl.fileWriteContents(file, configData);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toYaml(boolean pretty) {
        try {
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(this.style);
            if (pretty) {
                options.setPrettyFlow(true);
            }
            Yaml yaml = new Yaml(options);
            String configData = yaml.dump(this.configMap);
            return configData;
        }
        catch (Exception e) {
            return null;
        }
    }
}

