/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config.entry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;

public abstract class ConfigEntry<T> {
    public final class_2960 id;
    private final T defaultValue;
    private boolean synced;
    protected T value;
    private List<Consumer<class_2960>> listeners = List.of();

    public ConfigEntry(class_2960 id, T defaultValue) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.value = this.defaultValue;
    }

    public class_2960 getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (!Objects.equals(this.value, value)) {
            this.value = value;
            this.notifyChange();
        }
    }

    public abstract boolean isValidValue(Object var1);

    public abstract OptionValue<?> createUI(OptionsList var1, String var2, BiConsumer<class_2960, Object> var3);

    public void addListener(Consumer<class_2960> listener) {
        if (this.listeners.isEmpty()) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void notifyChange() {
        for (Consumer<class_2960> listener : this.listeners) {
            listener.accept(this.id);
        }
    }
}

