/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.trinkets;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.trinkets.BackpackTrinket;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;

public class TrinketsCompat
implements ICompat {
    private static final BackpackTrinket TRINKET_BACKPACK = new BackpackTrinket();
    private static final int TAGS_REFRESH_COOLDOWN = 100;
    private final Set<String> backpackTrinketIdentifiers = new HashSet<String>();
    private long lastTagsRefresh = -1L;

    public static <T> T getFromTrinketInventory(class_1657 player, String identifier, Function<TrinketInventory, T> getFromHandler, T defaultValue) {
        return (T)TrinketsApi.getTrinketComponent((class_1309)player).map(comp -> {
            Map group;
            String[] identifiers = identifier.split("/");
            if (identifiers.length == 2 && comp.getInventory().containsKey(identifiers[0]) && (group = (Map)comp.getInventory().get(identifiers[0])).containsKey(identifiers[1])) {
                return getFromHandler.apply((TrinketInventory)group.get(identifiers[1]));
            }
            return defaultValue;
        }).orElse(defaultValue);
    }

    public static boolean isTrinketContainer(class_1263 container) {
        return container instanceof TrinketInventory;
    }

    public static String getIdentifierForSlot(class_1263 container) {
        if (container instanceof TrinketInventory) {
            TrinketInventory trinketInventory = (TrinketInventory)container;
            return trinketInventory.getSlotType().getGroup() + "/" + trinketInventory.getSlotType().getName();
        }
        return "";
    }

    public void init() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("trinkets", this::getTrinketTags, (player, identifier) -> TrinketsCompat.getFromTrinketInventory(player, identifier, TrinketInventory::method_5439, 0), (player, identifier, slot) -> TrinketsCompat.getFromTrinketInventory(player, identifier, ti -> ti.method_5438(slot), class_1799.field_8037), false, true, true, true);
    }

    public void setup() {
        for (Supplier<BackpackItem> backpack : ModItems.BACKPACKS) {
            TrinketsApi.registerTrinket((class_1792)((class_1792)backpack.get()), (Trinket)TRINKET_BACKPACK);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            TrinketRendererRegistry.registerRenderer((class_1792)((class_1792)backpack.get()), (TrinketRenderer)TRINKET_BACKPACK);
        }
    }

    private Set<String> getTrinketTags(class_1657 player, long gameTime) {
        if (this.lastTagsRefresh + 100L < gameTime) {
            this.lastTagsRefresh = gameTime;
            this.backpackTrinketIdentifiers.clear();
            TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(comp -> {
                class_1799 backpack = new class_1799((class_1935)ModItems.BACKPACK.get());
                for (Map.Entry group : comp.getInventory().entrySet()) {
                    for (Map.Entry inventory : ((Map)group.getValue()).entrySet()) {
                        TrinketInventory trinketInventory = (TrinketInventory)inventory.getValue();
                        SlotType slotType = trinketInventory.getSlotType();
                        for (int i = 0; i < trinketInventory.method_5439(); ++i) {
                            SlotReference ref = new SlotReference(trinketInventory, i);
                            if (!TrinketsApi.evaluatePredicateSet((Set)slotType.getValidatorPredicates(), (class_1799)backpack, (SlotReference)ref, (class_1309)player)) continue;
                            this.backpackTrinketIdentifiers.add((String)group.getKey() + "/" + (String)inventory.getKey());
                        }
                    }
                }
            });
        }
        return this.backpackTrinketIdentifiers;
    }
}

