/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final List<class_2960> notInclude = new ArrayList<class_2960>();
    protected final List<T> builder = new ArrayList<T>();
    private final MapRegistry<T> valuesReg;
    private final Class<T> typeClass;
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();

    public static Codec<BlockTypeRegistry<?>> getRegistryCodec() {
        return BlockSetInternal.REGISTRIES_BY_NAME;
    }

    public static class_9139<class_2540, BlockTypeRegistry<?>> getRegistryStreamCodec() {
        return BlockSetInternal.REGISTRIES_BY_NAME.getStreamCodec();
    }

    protected BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
        this.valuesReg = new MapRegistry(name);
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    @Deprecated(forRemoval=true)
    public T getFromNBT(String name) {
        return (T)((BlockType)this.valuesReg.getValueOrDefault(class_2960.method_60654((String)name), this.getDefaultType()));
    }

    @Nullable
    public T get(class_2960 res) {
        return (T)((BlockType)this.valuesReg.getValue(res));
    }

    public class_2960 getKey(T input) {
        return this.valuesReg.getKey(input);
    }

    public Codec<T> getCodec() {
        return this.valuesReg;
    }

    public class_9139<class_2540, T> getStreamCodec() {
        return this.valuesReg.getStreamCodec();
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return this.valuesReg.getValues();
    }

    public String typeName() {
        return this.name;
    }

    public abstract Optional<T> detectTypeFromBlock(class_2248 var1, class_2960 var2);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a wood types after registry events");
        }
        this.builder.add(newType);
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(class_2960 id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    protected void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<String> modOrder = new ArrayList<String>();
        modOrder.add("minecraft");
        this.builder.forEach(e -> {
            String modId = e.getNamespace();
            if (!modOrder.contains(modId)) {
                modOrder.add(modId);
            }
        });
        for (String string : modOrder) {
            this.builder.forEach(e -> {
                if (Objects.equals(e.getNamespace(), modId) && !linkedHashMap.containsKey(e.getId())) {
                    linkedHashMap.put(e.getId(), e);
                }
            });
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this.valuesReg.register((class_2960)entry.getKey(), (BlockType)entry.getValue());
        }
        this.builder.clear();
        this.frozen = true;
    }

    @ApiStatus.Internal
    public void onBlockInit() {
        this.getValues().forEach(BlockType::initializeChildrenBlocks);
    }

    @ApiStatus.Internal
    public void onItemInit() {
        this.getValues().forEach(BlockType::initializeChildrenItems);
    }

    @ApiStatus.Internal
    public void buildAll() {
        if (!this.frozen) {
            this.registerBlockType(this.getDefaultType());
            this.finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (class_2248 b : class_7923.field_41175) {
                this.detectTypeFromBlock(b, Utils.getID(b)).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finders.clear();
            this.notInclude.clear();
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }

    @Nullable
    public T getBlockTypeOf(class_1935 itemLike) {
        BlockType t = (BlockType)this.childrenToType.get((Object)itemLike);
        if (t != null) {
            return (T)t;
        }
        if (itemLike instanceof class_1747) {
            class_1747 bi = (class_1747)itemLike;
            return (T)((BlockType)this.childrenToType.get((Object)bi.method_7711()));
        }
        if (itemLike instanceof class_2248) {
            class_2248 b = (class_2248)itemLike;
            return (T)((BlockType)this.childrenToType.get((Object)b.method_8389()));
        }
        return null;
    }

    protected void mapObjectToType(Object itemLike, BlockType type) {
        class_1747 bi;
        this.childrenToType.put(itemLike, (Object)type);
        if (itemLike instanceof class_1747 && !this.childrenToType.containsKey((Object)(bi = (class_1747)itemLike).method_7711())) {
            this.childrenToType.put((Object)bi.method_7711(), (Object)type);
        }
    }
}

