/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.map;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.fabric.MapDataInternalImpl;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9209;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MapDataInternal {
    public static final MapRegistry<CustomMapData.Type<?, ?>> CUSTOM_MAP_DATA_TYPES = new MapRegistry("custom_map_data_types");
    public static final class_5321<class_2378<MLMapDecorationType<?, ?>>> KEY = class_5321.method_29180((class_2960)Moonlight.res("map_marker"));
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final MapRegistry<Supplier<MLSpecialMapDecorationType<?, ?>>> CODE_TYPES_FACTORIES = new MapRegistry("code_map_decoration_types_factories");
    private static final List<TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>>> DYNAMIC_SERVER = Collections.synchronizedList(new ArrayList());
    private static final List<BiFunction<class_9209, class_22, Set<MLMapMarker<?>>>> DYNAMIC_CLIENT = Collections.synchronizedList(new ArrayList());

    public static <P, T extends CustomMapData<?, P>> CustomMapData.Type<P, T> registerCustomMapSavedData(CustomMapData.Type<P, T> type) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + String.valueOf(type.id()));
        }
        CUSTOM_MAP_DATA_TYPES.register(type.id(), type);
        return type;
    }

    public static MLMapDecorationType<?, ?> getGenericStructure() {
        return MapDataInternal.getOrDefault(GENERIC_STRUCTURE_ID);
    }

    public static void registerCustomType(class_2960 id, Supplier<MLSpecialMapDecorationType<?, ?>> decorationType) {
        CODE_TYPES_FACTORIES.register(id, decorationType);
    }

    public static MLSpecialMapDecorationType<?, ?> createCustomType(class_2960 factoryID) {
        Supplier<MLSpecialMapDecorationType<?, ?>> factory = Objects.requireNonNull(CODE_TYPES_FACTORIES.getValue(factoryID), "No map decoration type with id: " + String.valueOf(factoryID));
        MLSpecialMapDecorationType<?, ?> specialType = factory.get();
        specialType.factoryID = factoryID;
        return specialType;
    }

    public static MLMapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        for (MLMapDecorationType<?, ?> v : MapDataInternal.getValues()) {
            Optional<class_6885<class_3195>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().method_40241(structure)) continue;
            return v;
        }
        return MapDataInternal.getGenericStructure();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDataInternalImpl.init();
    }

    @Deprecated(forRemoval=true)
    public static class_2378<MLMapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(KEY);
    }

    public static class_2378<MLMapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(KEY);
    }

    @Deprecated(forRemoval=true)
    public static Collection<MLMapDecorationType<?, ?>> getValues() {
        return MapDataInternal.hackyGetRegistry().method_10220().toList();
    }

    @Deprecated(forRemoval=true)
    public static Set<Map.Entry<class_5321<MLMapDecorationType<?, ?>>, MLMapDecorationType<?, ?>>> getEntries() {
        return MapDataInternal.hackyGetRegistry().method_29722();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static MLMapDecorationType<? extends MLMapDecoration, ?> getOrDefault(String id) {
        return MapDataInternal.getOrDefault(class_2960.method_60654((String)id));
    }

    @Deprecated(forRemoval=true)
    public static MLMapDecorationType<?, ?> getOrDefault(class_2960 id) {
        class_2378<MLMapDecorationType<?, ?>> reg = MapDataInternal.hackyGetRegistry();
        MLMapDecorationType r = (MLMapDecorationType)reg.method_10223(id);
        if (r == null) {
            return (MLMapDecorationType)reg.method_10223(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_6880<MLMapDecorationType<?, ?>> getHolder(class_2960 id) {
        return MapDataInternal.hackyGetRegistry().method_55841(id).orElse(null);
    }

    @Deprecated(forRemoval=true)
    public static Optional<MLMapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDataInternal.hackyGetRegistry().method_17966(id);
    }

    public static Set<MLMapMarker<?>> getDynamicServer(class_1657 player, class_9209 mapId, class_22 data) {
        HashSet dynamic = new HashSet();
        for (TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>> v : DYNAMIC_SERVER) {
            dynamic.addAll((Collection)v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MLMapMarker<?>> getDynamicClient(class_9209 mapId, class_22 data) {
        HashSet dynamic = new HashSet();
        for (BiFunction<class_9209, class_22, Set<MLMapMarker<?>>> v : DYNAMIC_CLIENT) {
            dynamic.addAll((Collection)v.apply(mapId, data));
        }
        return dynamic;
    }

    public static List<MLMapMarker<?>> getMarkersFromWorld(class_1922 reader, class_2338 pos) {
        ArrayList list = new ArrayList();
        for (MLMapDecorationType<?, ?> type : MapDataInternal.getValues()) {
            Object c = type.createMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MLMapMarker<?>)c);
        }
        return list;
    }

    public static void addDynamicClientMarkersEvent(BiFunction<class_9209, class_22, Set<MLMapMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, class_9209, class_22, Set<MLMapMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }
}

