/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.registry;

import io.github.thecsdev.betterstats.api.util.formatters.StatValueFormatter;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.registry.TMutableRegistry;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BSRegistries {
    public static final Map<String, Function<class_2960, String>> ITEM_WIKIS;
    public static final Map<String, Function<class_2960, String>> MOB_WIKIS;
    @Deprecated(since="3.9.1", forRemoval=true)
    public static final Map<class_3448<class_1299<?>>, Function<SUMobStat, class_2561>> ENTITY_STAT_TEXT_FORMATTER;
    public static final Map<class_3448<class_1299<?>>, class_2561> ENTITY_STAT_PHRASE;
    @ApiStatus.Experimental
    public static final TMutableRegistry<StatValueFormatter> STAT_TIME_FORMATTER;
    @ApiStatus.Experimental
    public static final TMutableRegistry<StatValueFormatter> STAT_DISTANCE_FORMATTER;

    private BSRegistries() {
    }

    @Nullable
    public static final String getItemWikiURL(class_2960 itemId) throws NullPointerException {
        Objects.requireNonNull(itemId);
        Function<class_2960, String> supplier = ITEM_WIKIS.get(itemId.method_12836());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(itemId);
    }

    @Nullable
    public static final String getMobWikiURL(class_2960 entityId) throws NullPointerException {
        Objects.requireNonNull(entityId);
        Function<class_2960, String> supplier = MOB_WIKIS.get(entityId.method_12836());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(entityId);
    }

    public static final class_2561 getEntityStatTypePhrase(class_3448<class_1299<?>> statType) {
        if (statType == null) {
            return TextUtils.literal((String)"null");
        }
        class_2561 esp = ENTITY_STAT_PHRASE.get(statType);
        if (esp != null) {
            return esp;
        }
        class_2960 statTypeId = class_7923.field_41193.method_10221(statType);
        if (statTypeId != null) {
            class_5250 phrase;
            String stKey = statTypeId.toString().replace(':', '.');
            String tKey = "betterstats.stattype_phrase." + stKey;
            if (!Objects.equals(tKey, (phrase = class_2561.method_43471((String)tKey)).getString())) {
                return phrase;
            }
            return TextUtils.literal((String)statTypeId.toString());
        }
        return TextUtils.literal((String)"null");
    }

    static {
        STAT_TIME_FORMATTER = new TMutableRegistry();
        STAT_DISTANCE_FORMATTER = new TMutableRegistry();
        ITEM_WIKIS = new TreeMap<String, Function<class_2960, String>>(String.CASE_INSENSITIVE_ORDER);
        MOB_WIKIS = new TreeMap<String, Function<class_2960, String>>(String.CASE_INSENSITIVE_ORDER);
        ENTITY_STAT_TEXT_FORMATTER = new HashMap();
        ENTITY_STAT_PHRASE = new HashMap();
        String mc = class_2960.method_60654((String)"air").method_12836();
        ITEM_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.method_12832());
        MOB_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.method_12832());
        ENTITY_STAT_TEXT_FORMATTER.put(class_3468.field_15403, stat -> TextUtils.literal((String)"").method_10852(BSRegistries.getEntityStatTypePhrase(class_3468.field_15403)).method_27693(": " + stat.kills));
        ENTITY_STAT_TEXT_FORMATTER.put(class_3468.field_15411, stat -> TextUtils.literal((String)"").method_10852(BSRegistries.getEntityStatTypePhrase(class_3468.field_15411)).method_27693(": " + stat.deaths));
        ENTITY_STAT_PHRASE.put(class_3468.field_15403, (class_2561)BST.stp_mc_killed());
        ENTITY_STAT_PHRASE.put(class_3468.field_15411, (class_2561)BST.stp_mc_killedBy());
    }
}

