/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.caffeinemc.mods.lithium.common.shapes.VoxelShapeAlignedCuboid;
import net.caffeinemc.mods.lithium.common.shapes.lists.OffsetFractionalDoubleList;
import net.minecraft.class_2335;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_251;
import net.minecraft.class_265;
import net.minecraft.class_3532;

public class VoxelShapeAlignedCuboidOffset
extends VoxelShapeAlignedCuboid {
    private final double xOffset;
    private final double yOffset;
    private final double zOffset;

    public VoxelShapeAlignedCuboidOffset(VoxelShapeAlignedCuboid originalShape, class_251 voxels, double xOffset, double yOffset, double zOffset) {
        super(voxels, originalShape.minX + xOffset, originalShape.minY + yOffset, originalShape.minZ + zOffset, originalShape.maxX + xOffset, originalShape.maxY + yOffset, originalShape.maxZ + zOffset, originalShape.xyzResolution);
        if (originalShape instanceof VoxelShapeAlignedCuboidOffset) {
            this.xOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).xOffset + xOffset;
            this.yOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).yOffset + yOffset;
            this.zOffset = ((VoxelShapeAlignedCuboidOffset)originalShape).zOffset + zOffset;
        } else {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }
    }

    @Override
    public class_265 method_1096(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.field_1401, x, y, z);
    }

    @Override
    public double method_1103(class_2335 cycleDirection, class_238 box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(class_2335 dir, class_238 box, double maxDist) {
        switch (dir) {
            case field_10962: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minX, this.maxX, this.getXSegments(), this.xOffset, box.field_1323, box.field_1320, maxDist);
            }
            case field_10963: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minZ, this.maxZ, this.getZSegments(), this.zOffset, box.field_1321, box.field_1324, maxDist);
            }
            case field_10965: {
                return VoxelShapeAlignedCuboidOffset.calculatePenetration(this.minY, this.maxY, this.getYSegments(), this.yOffset, box.field_1322, box.field_1325, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double shapeOffset, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            int segment = class_3532.method_15384((double)((bMax - 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
            double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
            if (wallPos < bMax - 1.0E-7) {
                wallPos = (double)(++segment) / (double)segmentsPerUnit + shapeOffset;
            }
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        int segment = class_3532.method_15357((double)((bMin + 1.0E-6 - shapeOffset) * (double)segmentsPerUnit));
        double wallPos = (double)segment / (double)segmentsPerUnit + shapeOffset;
        if (wallPos > bMin + 1.0E-7) {
            wallPos = (double)(--segment) / (double)segmentsPerUnit + shapeOffset;
        }
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList method_1109(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> new OffsetFractionalDoubleList(this.getXSegments(), this.xOffset);
            case class_2350.class_2351.field_11052 -> new OffsetFractionalDoubleList(this.getYSegments(), this.yOffset);
            case class_2350.class_2351.field_11051 -> new OffsetFractionalDoubleList(this.getZSegments(), this.zOffset);
        };
    }

    @Override
    protected double method_1099(class_2350.class_2351 axis, int index) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> this.xOffset + (double)index / (double)this.getXSegments();
            case class_2350.class_2351.field_11052 -> this.yOffset + (double)index / (double)this.getYSegments();
            case class_2350.class_2351.field_11051 -> this.zOffset + (double)index / (double)this.getZSegments();
        };
    }

    @Override
    protected int method_1100(class_2350.class_2351 axis, double coord) {
        int numSegments;
        coord = switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> {
                numSegments = this.getXSegments();
                yield (coord - this.xOffset) * (double)numSegments;
            }
            case class_2350.class_2351.field_11052 -> {
                numSegments = this.getYSegments();
                yield (coord - this.yOffset) * (double)numSegments;
            }
            case class_2350.class_2351.field_11051 -> {
                numSegments = this.getZSegments();
                yield (coord - this.zOffset) * (double)numSegments;
            }
        };
        return class_3532.method_15340((int)class_3532.method_15357((double)coord), (int)-1, (int)numSegments);
    }
}

