/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.MenuBuilder;
import noobanidus.mods.lootr.common.api.client.ClientTextureType;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import org.jetbrains.annotations.Nullable;

public interface ILootrAPI {
    public Set<UUID> getPlayerIds();

    public MinecraftServer getServer();

    default public int getCurrentTicks() {
        MinecraftServer server = this.getServer();
        if (server == null) {
            return -1;
        }
        return server.method_3780();
    }

    public boolean isFakePlayer(class_1657 var1);

    default public boolean clearPlayerLoot(class_3222 entity) {
        return this.clearPlayerLoot(entity.method_5667());
    }

    public boolean clearPlayerLoot(UUID var1);

    @Nullable
    public ILootrInventory getInventory(ILootrInfoProvider var1, class_3222 var2, LootFiller var3);

    @Nullable
    public ILootrInventory getInventory(ILootrInfoProvider var1, class_3222 var2, LootFiller var3, MenuBuilder var4);

    @Nullable
    public ILootrSavedData getData(ILootrInfoProvider var1);

    public long getLootSeed(long var1);

    public boolean shouldDiscard();

    public float getExplosionResistance(class_2248 var1, float var2);

    public boolean isBlastResistant();

    public boolean isBlastImmune();

    public float getDestroyProgress(class_2680 var1, class_1657 var2, class_1922 var3, class_2338 var4, float var5);

    public int getAnalogOutputSignal(class_2680 var1, class_1937 var2, class_2338 var3, int var4);

    public boolean shouldPowerComparators();

    public boolean shouldNotify(int var1);

    public int getNotificationDelay();

    public boolean isNotificationsEnabled();

    public boolean isMessageStylesEnabled();

    public ClientTextureType getTextureType();

    default public boolean isNewTextures() {
        return this.getTextureType() == ClientTextureType.NEW;
    }

    default public boolean isOldTextures() {
        return this.getTextureType() == ClientTextureType.OLD;
    }

    default public boolean isVanillaTextures() {
        return this.getTextureType() == ClientTextureType.VANILLA;
    }

    default public boolean isDefaultTextures() {
        return this.getTextureType() == ClientTextureType.NEW;
    }

    public boolean isDisabled();

    public boolean isLootTableBlacklisted(class_5321<class_52> var1);

    public boolean isDimensionBlocked(class_5321<class_1937> var1);

    public boolean isDimensionDecaying(class_5321<class_1937> var1);

    public boolean isDimensionRefreshing(class_5321<class_1937> var1);

    public Set<class_5321<class_1937>> getDimensionBlacklist();

    public Set<class_5321<class_1937>> getDimensionWhitelist();

    public Set<class_5321<class_52>> getLootTableBlacklist();

    public Set<String> getLootModidBlacklist();

    public Set<String> getModidDimensionWhitelist();

    public Set<String> getModidDimensionBlacklist();

    public boolean isDecaying(ILootrInfoProvider var1);

    public boolean isRefreshing(ILootrInfoProvider var1);

    public Set<String> getModidDecayWhitelist();

    public Set<class_5321<class_52>> getDecayWhitelist();

    public Set<class_5321<class_1937>> getDecayDimensions();

    public Set<String> getRefreshModids();

    public Set<class_5321<class_52>> getRefreshWhitelist();

    public Set<class_5321<class_1937>> getRefreshDimensions();

    public boolean reportUnresolvedTables();

    public boolean isCustomTrapped();

    public boolean isWorldBorderSafe(class_1937 var1, class_2338 var2);

    public boolean isWorldBorderSafe(class_1937 var1, class_1923 var2);

    public boolean shouldCheckWorldBorder();

    public int getMaximumAge();

    public boolean hasExpired(long var1);

    public boolean shouldConvertMineshafts();

    public boolean shouldConvertElytras();

    public int getDecayValue();

    public boolean shouldDecayAll();

    public int getRefreshValue();

    public boolean shouldRefreshAll();

    public class_2583 getInvalidStyle();

    public class_2583 getDecayStyle();

    public class_2583 getRefreshStyle();

    public class_2583 getChatStyle();

    public class_2561 getInvalidTableComponent(class_5321<class_52> var1);

    public boolean canDestroyOrBreak(class_1657 var1);

    public boolean isBreakDisabled();

    public boolean isBreakEnabled();

    public boolean isFakePlayerBreakEnabled();

    public boolean shouldDropPlayerLoot();

    public boolean shouldPerformDecayWhileTicking();

    public boolean shouldPerformRefreshWhileTicking();

    public boolean shouldStartDecayWhileTicking();

    public boolean shouldStartRefreshWhileTicking();

    public boolean performPiecewiseCheck();

    default public boolean isAwarded(ILootrInfoProvider provider, class_3222 player) {
        return this.isAwarded(provider.getInfoUUID(), player);
    }

    public boolean isAwarded(UUID var1, class_3222 var2);

    default public void award(ILootrInfoProvider provider, class_3222 player) {
        this.award(provider.getInfoUUID(), player);
    }

    public void award(UUID var1, class_3222 var2);

    public int getRemainingDecayValue(ILootrInfoProvider var1);

    public boolean isDecayed(ILootrInfoProvider var1);

    public void setDecaying(ILootrInfoProvider var1);

    public void removeDecayed(ILootrInfoProvider var1);

    public int getRemainingRefreshValue(ILootrInfoProvider var1);

    public boolean isRefreshed(ILootrInfoProvider var1);

    public void setRefreshing(ILootrInfoProvider var1);

    public void removeRefreshed(ILootrInfoProvider var1);

    @Nullable
    public class_2680 replacementBlockState(class_2680 var1);

    public void handleProviderSneak(@Nullable ILootrInfoProvider var1, class_3222 var2);

    public void handleProviderOpen(@Nullable ILootrInfoProvider var1, class_3222 var2);

    public void handleProviderTick(@Nullable ILootrInfoProvider var1);

    public boolean anyUnloadedChunks(class_5321<class_1937> var1, Set<class_1923> var2);

    public <T extends class_2586> ILootrBlockEntity resolveBlockEntity(T var1);

    public <T extends class_1297> ILootrCart resolveEntity(T var1);

    public boolean isTaggedStructurePresent(class_3218 var1, class_1923 var2, class_6862<class_3195> var3, class_2338 var4);

    public void playerDestroyed(class_1937 var1, class_1657 var2, class_2338 var3, @Nullable class_2586 var4);
}

