/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.AdvancementData;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.TickingData;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.mixins.MixinDimensionDataStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class DataStorage {
    public static final String ADVANCEMENTS = "lootr/Lootr-AdvancementData";
    public static final String DECAYS = "lootr/Lootr-DecayData";
    public static final String REFRESHES = "lootr/Lootr-RefreshData";

    @ApiStatus.Internal
    @Nullable
    public static class_26 getDataStorage() {
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            LootrAPI.LOG.error("The Overworld is null at this stage; Lootr cannot fetch data storage.");
            return null;
        }
        return overworld.method_17983();
    }

    @ApiStatus.Internal
    public static boolean isAwarded(ILootrInfoProvider provider, class_3222 player) {
        return DataStorage.isAwarded(provider.getInfoUUID(), player);
    }

    @ApiStatus.Internal
    public static boolean isAwarded(UUID uuid, class_3222 player) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine if advancement has been awarded.");
            return false;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData.FACTORY, ADVANCEMENTS);
        return data.contains(player.method_5667(), uuid);
    }

    @ApiStatus.Internal
    public static void award(ILootrInfoProvider provider, class_3222 player) {
        DataStorage.award(provider.getInfoUUID(), player);
    }

    @ApiStatus.Internal
    public static void award(UUID id, class_3222 player) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot award advancement.");
            return;
        }
        AdvancementData data = (AdvancementData)manager.method_17924(AdvancementData.FACTORY, ADVANCEMENTS);
        data.add(player.method_5667(), id);
    }

    @ApiStatus.Internal
    public static int getDecayValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the decay value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        return data.getValue(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isDecayed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the decay value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        return data.isComplete(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void setDecaying(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the decay value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        data.setValue(provider.getInfoUUID(), LootrAPI.getDecayValue());
    }

    @ApiStatus.Internal
    public static void removeDecayed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr remove the decay value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, DECAYS);
        data.remove(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void doTick() {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot iterate and tick decay.");
            return;
        }
        ((TickingData)manager.method_17924(TickingData.FACTORY, DECAYS)).tick();
        ((TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES)).tick();
    }

    @ApiStatus.Internal
    public static int getRefreshValue(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the refresh value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return -1;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        return data.getValue(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static boolean isRefreshed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot determine the refresh value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return false;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        return data.isComplete(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static void setRefreshing(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot set the refresh value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        data.setValue(provider.getInfoUUID(), LootrAPI.getRefreshValue());
    }

    @ApiStatus.Internal
    public static void removeRefreshed(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr remove the refresh value for " + String.valueOf(provider.getInfoUUID()) + ".");
            return;
        }
        TickingData data = (TickingData)manager.method_17924(TickingData.FACTORY, REFRESHES);
        data.remove(provider.getInfoUUID());
    }

    @ApiStatus.Internal
    public static LootrSavedData getData(ILootrInfoProvider provider) {
        class_26 manager = DataStorage.getDataStorage();
        if (manager == null) {
            LootrAPI.LOG.error("DataStorage is null at this stage; Lootr cannot fetch data for " + String.valueOf(provider.getInfoDimension()) + " at " + String.valueOf(provider.getInfoPos()) + " with ID " + String.valueOf(provider.getInfoUUID()) + " and cannot continue.");
            return null;
        }
        LootrSavedData result = (LootrSavedData)manager.method_17924(new class_18.class_8645(LootrSavedData.fromInfo(provider), LootrSavedData::load, null), provider.getInfoKey());
        result.update(provider);
        return result;
    }

    @Nullable
    public static ILootrInventory getInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        LootrSavedData data = DataStorage.getData(provider);
        if (data == null) {
            return null;
        }
        return data.getOrCreateInventory(provider, player, filler);
    }

    @ApiStatus.Internal
    public static boolean clearInventories(class_1657 player) {
        return DataStorage.clearInventories(player.method_5667());
    }

    @ApiStatus.Internal
    public static boolean clearInventories(UUID id) {
        class_26 data = DataStorage.getDataStorage();
        if (data == null) {
            return false;
        }
        MinecraftServer server = LootrAPI.getServer();
        if (server == null) {
            LootrAPI.LOG.error("MinecraftServer is null at this stage; Lootr cannot clear inventories.");
            return false;
        }
        Path dataPath = server.method_27050(new class_5218("data")).resolve("lootr");
        ArrayList files = new ArrayList();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String fileName = path.getFileName().toString();
                    if (fileName.startsWith("Lootr-")) {
                        return;
                    }
                    files.add("lootr/" + fileName.charAt(0) + "/" + fileName.substring(0, 2) + "/" + fileName.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        int count = 0;
        for (String file : files) {
            class_18 datum = data.method_20786(new class_18.class_8645(() -> LootrDummyData.INSTANCE, LootrSavedData::load, null), file);
            if (datum == LootrDummyData.INSTANCE) {
                LootrAPI.LOG.error("Failed to load data for " + file + ", removing from cache.");
                ((MixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            if (!(datum instanceof LootrSavedData)) {
                LootrAPI.LOG.error("Data for " + file + " is not a LootrSavedData instance.");
                ((MixinDimensionDataStorage)data).getCache().remove(file);
                continue;
            }
            LootrSavedData lootrSavedData = (LootrSavedData)datum;
            if (!lootrSavedData.clearInventories(id)) continue;
            ++count;
        }
        if (count > 0) {
            data.method_125();
            LootrAPI.LOG.info("Cleared " + count + " inventories for play UUID " + id.toString());
            return true;
        }
        return false;
    }

    private static class LootrDummyData
    extends class_18 {
        public static final LootrDummyData INSTANCE = new LootrDummyData();

        public class_2487 method_75(class_2487 p_77763_, class_7225.class_7874 p_323640_) {
            return null;
        }
    }
}

