/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.data;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import noobanidus.mods.lootr.common.api.data.BaseLootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.data.LootrInventory;
import org.jetbrains.annotations.Nullable;

public class LootrSavedData
extends class_18
implements ILootrSavedData {
    private boolean hasBeenOpened;
    private boolean justLoaded;
    private ILootrInfo info;
    private final Map<UUID, LootrInventory> inventories = new HashMap<UUID, LootrInventory>();
    private final Set<UUID> openers = new ObjectLinkedOpenHashSet();
    private final Set<UUID> actualOpeners = new ObjectLinkedOpenHashSet();

    protected LootrSavedData(ILootrInfo info) {
        this.info = BaseLootrInfo.copy(info);
        this.justLoaded = false;
    }

    protected LootrSavedData(ILootrInfo info, boolean noCopy) {
        this.info = info;
        this.justLoaded = true;
    }

    public static Supplier<LootrSavedData> fromInfo(ILootrInfo info) {
        return () -> new LootrSavedData(info);
    }

    public static LootrSavedData load(class_2487 compound, class_7225.class_7874 provider) {
        ILootrInfo info = ILootrInfo.loadInfoFromTag(compound, provider);
        LootrSavedData data = new LootrSavedData(info, true);
        data.inventories.clear();
        data.openers.clear();
        data.actualOpeners.clear();
        class_2499 compounds = compound.method_10554("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            class_2487 thisTag = compounds.method_10602(i);
            class_2487 itemTag = thisTag.method_10562("chest");
            class_2371<class_1799> items = info.buildInitialInventory();
            class_1262.method_5429((class_2487)itemTag, items, (class_7225.class_7874)provider);
            UUID uuid = thisTag.method_25926("uuid");
            data.inventories.put(uuid, new LootrInventory(data, items));
        }
        if (compound.method_10545("openers")) {
            class_2499 openers = compound.method_10554("openers", 11);
            for (class_2520 opener : openers) {
                data.openers.add(class_2512.method_25930((class_2520)opener));
            }
        }
        if (compound.method_10545("actualOpeners")) {
            class_2499 openers = compound.method_10554("actualOpeners", 11);
            for (class_2520 opener : openers) {
                data.actualOpeners.add(class_2512.method_25930((class_2520)opener));
            }
        }
        if (compound.method_10545("hasBeenOpened")) {
            data.hasBeenOpened = compound.method_10577("hasBeenOpened");
        }
        return data;
    }

    @Override
    public ILootrInfo getRedirect() {
        return this.info;
    }

    @Override
    public Set<UUID> getVisualOpeners() {
        return this.openers;
    }

    @Override
    public boolean addVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addVisualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    @Override
    public boolean removeVisualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.removeVisualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    @Override
    public boolean addActualOpener(UUID uuid) {
        boolean result = ILootrSavedData.super.addActualOpener(uuid);
        if (result) {
            this.method_80();
        }
        return result;
    }

    private void removeOpener(UUID uuid) {
        Set<UUID> visualOpeners = this.getVisualOpeners();
        if (visualOpeners != null && visualOpeners.remove(uuid)) {
            this.method_80();
        }
    }

    @Override
    public Set<UUID> getActualOpeners() {
        return this.actualOpeners;
    }

    @Override
    public void markChanged() {
        this.method_80();
    }

    @Override
    public void markDataChanged() {
        this.markChanged();
    }

    @Override
    @Nullable
    public LootrInventory getInventory(UUID id) {
        LootrInventory inventory = this.inventories.get(id);
        if (inventory != null) {
            inventory.setInfo(this);
        }
        return inventory;
    }

    @Override
    public LootrInventory createInventory(ILootrInfoProvider provider, class_3222 player, LootFiller filler) {
        LootrInventory result = new LootrInventory(this, provider.buildInitialInventory());
        filler.unpackLootTable(provider, (class_1657)player, result);
        this.inventories.put(player.method_5667(), result);
        this.hasBeenOpened = true;
        this.method_80();
        return result;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 provider) {
        this.info.saveInfoToTag(compound, provider);
        class_2499 compounds = new class_2499();
        for (Map.Entry<UUID, LootrInventory> entry : this.inventories.entrySet()) {
            class_2487 thisTag = new class_2487();
            thisTag.method_25927("uuid", entry.getKey());
            thisTag.method_10566("chest", (class_2520)entry.getValue().saveToTag(provider));
            compounds.add((Object)thisTag);
        }
        compound.method_10566("inventories", (class_2520)compounds);
        class_2499 openers = new class_2499();
        for (UUID opener : this.openers) {
            openers.add((Object)class_2512.method_25929((UUID)opener));
        }
        compound.method_10566("openers", (class_2520)openers);
        class_2499 class_24992 = new class_2499();
        for (UUID opener : this.actualOpeners) {
            class_24992.add((Object)class_2512.method_25929((UUID)opener));
        }
        compound.method_10566("actualOpeners", (class_2520)class_24992);
        compound.method_10556("hasBeenOpened", this.hasBeenOpened);
        return compound;
    }

    @Override
    public boolean shouldUpdate() {
        return this.justLoaded;
    }

    @Override
    public void update(ILootrInfo info) {
        if (this.shouldUpdate() || info.getInfoPos() != this.getInfoPos() || info.getInfoDimension() != this.getInfoDimension()) {
            this.markChanged();
            this.info = info;
            this.justLoaded = false;
        }
    }

    @Override
    public void refresh() {
        this.inventories.clear();
        this.hasBeenOpened = false;
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    public boolean clearInventories(UUID id) {
        if (this.inventories.remove(id) != null) {
            this.removeOpener(id);
            this.method_80();
            return true;
        }
        return false;
    }

    public void method_17919(File pFile, class_7225.class_7874 provider) {
        if (this.method_79()) {
            pFile.getParentFile().mkdirs();
        }
        super.method_17919(pFile, provider);
    }
}

