/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.neoforge.neoforge.mixin;

import com.fizzware.dramaticdoors.neoforge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.neoforge.blocks.TallDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.DoorInteractGoal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DoorInteractGoal.class})
public class DoorInteractGoalMixin {
    @Shadow
    protected boolean hasDoor;
    @Shadow
    protected Mob mob;
    @Shadow
    protected BlockPos doorPos = BlockPos.ZERO;

    @Inject(method={"isOpen()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectIsDoorOpen(CallbackInfoReturnable<Boolean> cir) {
        BlockState blockStateDD = this.mob.level().getBlockState(this.doorPos);
        if (this.hasDoor && blockStateDD.getBlock() instanceof TallDoorBlock) {
            cir.setReturnValue((Object)((Boolean)blockStateDD.getValue((Property)TallDoorBlock.OPEN)));
        }
        if (this.hasDoor && blockStateDD.getBlock() instanceof ShortDoorBlock) {
            cir.setReturnValue((Object)((Boolean)blockStateDD.getValue((Property)ShortDoorBlock.OPEN)));
        }
    }

    @Inject(method={"setOpen(Z)V"}, at={@At(value="TAIL")})
    private void injectSetDoorOpen(boolean open, CallbackInfo ci) {
        BlockState blockStateDD;
        if (this.hasDoor && (blockStateDD = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof TallDoorBlock) {
            ((TallDoorBlock)blockStateDD.getBlock()).setOpen((Entity)this.mob, this.mob.level(), blockStateDD, this.doorPos, open);
        }
        if (this.hasDoor && (blockStateDD = this.mob.level().getBlockState(this.doorPos)).getBlock() instanceof ShortDoorBlock) {
            ((ShortDoorBlock)blockStateDD.getBlock()).setOpen((Entity)this.mob, this.mob.level(), blockStateDD, this.doorPos, open);
        }
    }

    @Inject(method={"canUse()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/DoorBlock;isWoodenDoor(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void injectCanStart(CallbackInfoReturnable<Boolean> ci) {
        boolean bl = this.hasDoor = TallDoorBlock.isMobInteractable(this.mob.level(), this.doorPos) || ShortDoorBlock.isMobInteractable(this.mob.level(), this.doorPos);
        if (this.hasDoor) {
            ci.setReturnValue((Object)true);
        }
    }
}

